package com.kontakt.sdk.android.common.model;

/**
 * Represents namespace for eddystone devices
 */
public interface INamespace {
    /**
     * Gets namespace
     *
     * @return the namespace
     */
    String getNamespace();

    /**
     * Gets secure namespace
     *
     * @return the secure namespace
     */
    String getSecureNamespace();

    /**
     * Checks is namespace shuffled or not
     *
     * @return true or false
     */
    boolean isShuffled();

    /**
     * Checks if namespace is shared to you
     * @return true if this namespace is shared to you by other user
     */
    boolean isShared();
}
