package com.kontakt.sdk.android.common.model;

import java.util.UUID;

/**
 * Manager represents person using kontakt.io SDK.
 * The manager may belong to Company.
 * The Manager may have one of three roles: OPERATOR, ADMIN, SUPERUSER.
 * Once managers become the owners of beacons, they are the only who
 * is able to manipulate them.
 */
public interface IManager extends IModel {

    /**
     * Gets manager id.
     *
     * @return the id
     */
    UUID getId();

    /**
     * Gets supervisor id.
     *
     * @return the supervisor id
     */
    UUID getSupervisorId();

    /**
     * Gets first name.
     *
     * @return the first name
     */
    String getFirstName();

    /**
     * Gets last name.
     *
     * @return the last name
     */
    String getLastName();

    /**
     * Gets company.
     *
     * @return the company
     */
    ICompany getCompany();

    /**
     * Gets email.
     *
     * @return the email
     */
    String getEmail();

    /**
     * Gets unique id.
     *
     * @return the unique id
     */
    String getUniqueId();

    /**
     * Gets role.
     *
     * @return the role
     */
    Role getRole();

    /**
     * Provides number of private, public, shared devices or venues.
     *
     * @return the counters
     */
    ICounters getCounters();

    /**
     * The Manager's Role.
     */
    enum Role {
        /**
         * Manager who has SUPERUSER role has the following responsibilities and qualifications:
         * <ul>
         * <li>Listing subordinates</li>
         * <li>Assigning managers to supervisors</li>
         * <li>Assigning beacons to managers</li>
         * <li>creating/deleting managers</li>
         * </ul>.
         */
        SUPERUSER,
        /**
         * The ADMIN.
         * <ul>
         * <li>Assigning managers to supervisors</li>
         * <li>Assigning beacons to managers</li>
         * <li>creating/deleting managers</li>
         * </ul>.
         */
        ADMIN,
        /**
         * <ul>
         * <li>Assigning beacons to managers</li>
         * </ul>.
         */
        OPERATOR
    }
}
