package com.kontakt.sdk.android.common.model;

import android.os.Parcelable;

import java.util.List;

/**
 * Interface for resolved device ids from api. It consists of:
 * <ul>
 * <p>queriedBy - device id which was used to http request</p>
 * <p>resolved - resolved device id</p>
 * <p>uniqueId - unique id of resolved device</p>
 * <p>futureIds - set of device ids which will transmitted in the future</p>
 * <u/>
 *
 * @param <DEVICE_ID> - beacon or eddystone id
 */
public interface IFutureId<DEVICE_ID> extends Parcelable {
    String QUERIED_BY = "queriedBy";
    String RESOLVED = "resolved";
    String FUTURE_SHUFFLES = "futureId";
    String UNIQUE_ID = "uniqueId";

    DEVICE_ID getQueriedBy();

    DEVICE_ID getResolved();

    List<DEVICE_ID> getFutureIds();

    String getUniqueId();
}
