package com.kontakt.sdk.android.common.model;

import java.util.ArrayList;
import java.util.UUID;

/**
 * Firmware provides information concerning the Beacon embedded software that is
 * currently installed on it.
 */
public interface IFirmware {

    /**
     * Gets device type
     * @return {@link DeviceType} of target device
     */
    DeviceType getDeviceType();

    /**
     * Gets id.
     *
     * @return the id
     */
    UUID getId();

    /**
     * Gets name.
     *
     * @return the name
     */
    String getName();

    /**
     * Gets description.
     *
     * @return the description
     */
    String getDescription();

    /**
     * Gets valid versions.
     *
     * @return the valid versions
     */
    String getValidVersions();

    /**
     * Returns true if the firmware is important.
     *
     * @return the boolean
     */
    boolean isImportant();

    /**
     * Checks is firmware scheduled to update
     * @return the boolean value
     */
    boolean isScheduled();


    /**
     * Checks is firmware update not mandatory
     * @return the boolean
     */
    boolean isOptional();

    /**
     * Gets list of unique ids target devices
     * @return List of unique ids
     */
    ArrayList<String> getDeviceUniqueIdList();

    /**
     * Gets url with Firmware content to download.
     *
     * @return the url
     */
    String getUrl();
}
