package com.kontakt.sdk.android.common.model;

import com.kontakt.sdk.android.common.profile.DeviceProfile;
import java.util.List;
import java.util.UUID;

public interface IDevice extends IModel {

  /**
   * Gets id.
   *
   * @return the id
   */
  UUID getId();

  /**
   * Gets MAC address.
   * @return MAC address.
   */
  String getMacAddress();

  /**
   * Gets Proximity UUID.
   *
   * @return the proximity UUID value
   */
  UUID getProximityUUID();

  /**
   * Gets Major.
   *
   * @return the major value
   */
  int getMajor();

  /**
   * Gets Minor.
   *
   * @return the minor value
   */
  int getMinor();

  /**
   * Gets interval.
   *
   * @return the interval
   */
  int getInterval();

  /**
   * Gets name.
   *
   * @return the name
   */
  String getName();

  /**
   * Gets alias.
   *
   * @return the alias
   */
  String getAlias();

  /**
   * Gets tx power.
   *
   * @return the tx power
   */
  int getTxPower();

  /**
   * Gets venue.
   *
   * @return the venue
   */
  IVenue getVenue();

  /**
   * Gets unique id.
   *
   * @return the unique id
   */
  String getUniqueId();

  /**
   * Gets type.
   *
   * @return the type
   */
  DeviceType getDeviceType();

  /**
   * Gets manager id.
   *
   * @return the manager id
   */
  UUID getManagerId();

  /**
   * Gets actions count.
   *
   * @return the actions count
   */
  int getActionsCount();

  /**
   * Gets latitude of device
   *
   * @return the latitude
   */
  String getLatitude();

  /**
   * Gets longitude of device
   *
   * @return the longitude
   */
  String getLongitude();

  /**
   * Gets Access
   *
   * @return the access
   */
  Access getAccess();

  /**
   * Gets Specification
   *
   * @return the specification
   */
  Specification getSpecification();

  /**
   * Gets Model
   *
   * @return the model
   */
  Model getModel();

  /**
   * Gets DeviceProfile list
   *
   * @return the list
   */
  List<DeviceProfile> getDeviceProfiles();

  /**
   * Gets firmware version
   *
   * @return the firmware version
   */
  String getFirmwareVersion();

  /**
   * Gets instance id
   *
   * @return the instance id
   */
  String getInstanceId();

  /**
   * Gets url
   *
   * @return the url
   */
  String getUrl();

  /**
   * Gets namespace
   *
   * @return the namespace
   */
  String getNamespace();

  /**
   * Checks if device is shuffled
   *
   * @return true or false
   */
  boolean isShuffled();

  /**
   * Gets secure proximity uuid
   *
   * @return uuid
   */
  UUID getSecureProximityUUID();

  /**
   * Gets secure namespace
   *
   * @return the secure namespace
   */
  String getSecureNamespace();
}
