package com.kontakt.sdk.android.common.model;

import com.kontakt.sdk.android.common.util.ContentCategory;
import com.kontakt.sdk.android.common.FileData;

/**
 * Content action contains source url that redirects to content that may be
 * downloaded. The content is described by content category and content type.
 */
public interface IContentAction extends IAction {

    /**
     * Gets content length.
     *
     * @return the content length
     */
    int getContentLength();

    /**
     * Gets content type.
     *
     * @return the content type
     */
    String getContentType();

    /**
     * Gets content url.
     *
     * @return the content url
     */
    String getContentUrl();

    /**
     * Gets content category.
     *
     * @return the content category
     */
    ContentCategory getContentCategory();
}
