package com.kontakt.sdk.android.common.model;

import com.kontakt.sdk.android.common.profile.DeviceProfile;

import java.util.List;
import java.util.UUID;

/**
 * Config represents configuration which Beacon device must be updated with.
 * Once the real device becomes updated with parameters matching the Config
 * parameters, the pending Config is removed after sending back same Config(with same parameters)
 * with RESTClient by invoking applyConfig() method.
 */
public interface IConfig extends IModel {

    /**
     * Gets Config id.
     *
     * @return the id
     */
    UUID getId();

    /**
     * Gets beacon unique id.
     *
     * @return the beacon unique id
     */
    String getDeviceUniqueId();

    /**
     * Gets proximity uUID.
     *
     * @return the proximity uUID
     */
    UUID getProximityUUID();

    /**
     * Gets Eddystone namespace
     *
     * @return the namespace
     */
    String getNamespace();

    /**
     * Gets Eddystone Url
     *
     * @return the url
     */
    String getUrl();

    /**
     * Gets Instance Id
     *
     * @return the instance id
     */
    String getInstanceId();

    /**
     * Gets major.
     *
     * @return the major
     */
    int getMajor();

    /**
     * Gets minor.
     *
     * @return the minor
     */
    int getMinor();

    /**
     * Gets tx power.
     *
     * @return the tx power
     */
    int getTxPower();

    /**
     * Gets interval.
     *
     * @return the interval
     */
    int getInterval();

    /**
     * Gets device profiles
     *
     * @return the device profile
     */
    List<DeviceProfile> getDeviceProfiles();

    /**
     * Gets device name from config
     *
     * @return the device name
     */
    String getDeviceName();

    /**
     * Gets device password from config
     *
     * @return the device password
     */
    String getDevicePassword();

    /**
     * Checks if device is shuffled
     *
     * @return null, true or false
     */
    Boolean isShuffled();
}