package com.kontakt.sdk.android.common.model;

import java.util.UUID;

/**
 * Company model describes real Company registered in kontakt.io database.
 */
public interface ICompany extends IModel {

    /**
     * Gets id.
     *
     * @return the id
     */
    UUID getId();

    /**
     * Gets country code.
     *
     * @return the country code
     */
    String getCountryCode();

    /**
     * Gets name.
     *
     * @return the name
     */
    String getName();

    /**
     * Gets unique id.
     *
     * @return the unique id
     */
    String getUniqueId();
}
