package com.kontakt.sdk.android.common.model;

/**
 * The interface representing Config for Cloud Beacon device.
 */
public interface ICloudConfig extends IConfig {

    /**
     * Gets default sSID name.
     *
     * @return the default sSID name
     */
    String getDefaultSSIDName();

    /**
     * Gets default sSID key.
     *
     * @return the default sSID key
     */
    String getDefaultSSIDKey();

    /**
     * Gets default sSID auth.
     *
     * @return the default sSID auth
     */
    String getDefaultSSIDAuth();

    /**
     * Gets default sSID crypt.
     *
     * @return the default sSID crypt
     */
    String getDefaultSSIDCrypt();

    /**
     * Gets password.
     *
     * @return the password
     */
    String getPassword();

    /**
     * Gets name.
     *
     * @return the name
     */
    String getName();

    /**
     * Gets working mode.
     *
     * @return the working mode
     */
    ICloudBeacon.WorkingMode getWorkingMode();

    /**
     * Gets wifi scan interval.
     *
     * @return the wifi scan interval
     */
    int getWifiScanInterval();

    /**
     * Gets data send interval.
     *
     * @return the data send interval
     */
    int getDataSendInterval();

    /**
     * Gets ble scan interval.
     *
     * @return the ble scan interval
     */
    int getBleScanInterval();

    /**
     * Gets ble scan duration.
     *
     * @return the ble scan duration
     */
    int getBleScanDuration();
}
