package com.kontakt.sdk.android.common.model;

/**
 * ICloudBeacon provids
 */
public interface ICloudBeacon extends IModel {
    /**
     * Gets wifi scan interval.
     *
     * @return the wifi scan interval
     */
    int getWifiScanInterval();

    /**
     * Gets bLE scan duration.
     *
     * @return the bLE scan duration
     */
    int getBLEScanDuration();

    /**
     * Gets working mode.
     *
     * @return the working mode
     */
    WorkingMode getWorkingMode();

    HashingPolicy getHashingPolicy();

    /**
     * Gets default sSID auth.
     *
     * @return the default sSID auth
     */
    String getDefaultSSIDAuth();

    /**
     * Gets mainenance start time.
     *
     * @return the mainenance start time
     */
    String getMaintenanceStart();

    /**
     * Gets data send interval.
     *
     * @return the data send interval
     */
    int getDataSendInterval();

    /**
     * Gets default sSID crypt.
     *
     * @return the default sSID crypt
     */
    String getDefaultSSIDCrypt();

    /**
     * Gets ble scan interval.
     *
     * @return the ble scan interval
     */
    int getBleScanInterval();

    /**
     * Gets default sSID name.
     *
     * @return the default sSID name
     */
    String getDefaultSSIDName();

    /**
     * Gets maintenance end time.
     *
     * @return the maintenance end time
     */
    String getMaintenanceEnd();

    /**
     * The enum Working mode.
     */
    enum WorkingMode {
        /**
         * The NONE.
         */
        NONE,
        /**
         * The BEACON.
         */
        BEACON,
        /**
         * The WIFI.
         */
        WIFI,
        /**
         * The BOTH.
         */
        BOTH
    }

    /**
     * The enum Hashing policy.
     * ALWAYS (default), NEVER - hash MAC addresses in analytics
     */
    enum HashingPolicy {
        ALWAYS, NEVER
    }

}
