package com.kontakt.sdk.android.common.model;

/**
 * BrandedPlace interface describes a place signified by Image cover that can be named and
 * provided with description concerning its existence.
 */
public interface IBrandedPlace extends IModel {
    /**
     * Gets image url.
     *
     * @return the image url
     */
    String getImageUrl();

    /**
     * Gets name.
     *
     * @return the name
     */
    String getName();

    /**
     * Gets description.
     *
     * @return the description
     */
    String getDescription();
}
