package com.kontakt.sdk.android.common.model;

import java.util.UUID;

/**
 * Beacon model represents JSON model of Beacon device with kontakt.io logic
 * applied.
 *
 * Beacon is a property of a Manager ({@link IManager}).
 * It acts also as a container for Actions and may be assigned to certain
 * Venue ({@link IVenue}).
 */
public interface IBeacon extends IModel {

    /**
     * Gets Beacon id.
     *
     * @return the id
     */
    UUID getId();

    /**
     * Gets manager id.
     *
     * @return the manager id
     */
    UUID getManagerId();

    /**
     * Gets tx power.
     *
     * @return the tx power
     */
    int getTxPower();

    /**
     * Gets Beacon name.
     *
     * @return the name
     */
    String getName();

    /**
     * Gets Beacon alias.
     *
     * @return the alias
     */
    String getAlias();

    /**
     * Gets interval.
     *
     * @return the interval
     */
    int getInterval();

    /**
     * Gets Beacon unique id.
     *
     * @return the unique id
     */
    String getUniqueId();

    /**
     * Gets actions count.
     *
     * @return the actions count
     */
    int getActionsCount();

    /**
     * Gets venue that that this Beacon belongs to.
     *
     * @return the venue
     */
    IVenue getVenue();
}
