package com.kontakt.sdk.android.common.model;


import com.kontakt.sdk.android.common.Proximity;

import java.util.UUID;

/**
 * Actions are the properties of Proximity Sources. Their goal is to provide information depending on the proximity
 * ({@link Proximity}) from the Source that they are assigned to.
 */
public interface IAction extends IModel {

    /**
     * Gets Action id.
     *
     * @return the id
     */
    UUID getId();

    /**
     * Gets proximity.
     *
     * @return the proximity
     */
    Proximity getProximity();

    /**
     * Gets Action type.
     *
     * @return the type
     */
    ActionType getType();

    /**
     * Gets Proximity Source.
     * <p/>
     * Might be null
     *
     * @return the proximity source
     */
    IDevice getDevice();

    /**
     * Action type specifies what kind of information can be retrieved from Action.
     */
    enum ActionType {
        /**
         * The BROWSER constant specifies that Action provides information incorporated in URL address.
         */
        BROWSER,
        /**
         * The CONTENT constants specifies that Action provides content available to download from content URL.
         */
        CONTENT
    }
}
