package com.kontakt.sdk.android.common.model;

/**
 * Abstract model provides abstraction for all classes in model package.
 */
abstract class AbstractModel implements IModel {

    /**
     * The constant PARCELABLE_FLAG_EXCLUDE_VENUE informs that Venue instance
     * should not be parceled when it comes to parceling Beacon. Due to the fact
     * that Venue is also a property of Beacon, a circular dependency is
     * eliminated.
     */
    static final int PARCELABLE_FLAG_EXCLUDE_VENUE = 0x01;

    /**
     * The constant PARCELABLE_FLAG_EXCLUDE_BEACON informs that Beacon instance
     * should not be parceled when it comes to parceling Actions. Due to the
     * fact that Beacon is also a property of Action, a circular dependency is
     * eliminated.
     */
    static final int PARCELABLE_FLAG_EXCLUDE_BEACON = 0x02;

    /**
     * The constant flag PARCELABLE_FLAG_EXCLUDE_ACTIONS informs that
     * Beacon instance should not include actions.
     */
    static final int PARCELABLE_FLAG_EXCLUDE_ACTIONS = 0x04;

    /**
     * Parceling convenience constant.
     */
    static final String PARCELABLE_HAS_VENUE = "parcelable_has_venue";
    /**
     * Parceling convenience constant.
     */
    static final String PARCELABLE_HAS_BEACON = "parcelable_has_beacon";

    /**
     * Parceling convenience constant.
     */
    static final String PARCELABLE_HAS_ACTIONS = "parcelable_has_actions";

    /**
     * The Database id. The database Id was introduced once
     * you decide to persist your model in local storage (e.g.
     * {@link android.database.sqlite.SQLiteDatabase}). If you
     * do not need to use it, ignore it during model building.
     */
    protected final int databaseId;

    /**
     * Instantiates a new Abstract model.
     *
     * @param databaseId the database id
     */
    protected AbstractModel(int databaseId) {
        this.databaseId = databaseId;
    }

    /**
     * Gets database id.
     *
     * @return the database id
     */
    public int getDatabaseId() {
        return databaseId;
    }

    @Override
    public int describeContents() {
        return 0;
    }
}
