/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import android.os.Messenger;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.manager.ProximityManager;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.Callbacks;
import com.kontakt.sdk.android.ble.service.CallbacksL;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.ListenerAccessor;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.RunnersL;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanConfigurationL;
import com.kontakt.sdk.android.ble.service.ScanController;
import com.kontakt.sdk.android.common.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ScanCompat {
    private static final List<ScanFilter> EMPTY_SCAN_FILTERS = new ArrayList<ScanFilter>();

    private ScanCompat() {
    }

    @TargetApi(value=21)
    static ScanConfiguration createScanConfiguration(ListenerAccessor listenerAccessor, ScanContext scanContext, Messenger messenger) {
        BleScanCallback scanCallback = Callbacks.newCallback(new Callbacks.Configuration.Builder().addMonitoringListeners(listenerAccessor.getMonitoringListeners()).setScanContext(scanContext).setServiceMessenger(messenger).build());
        if (ScanCompat.isLollipopOrHigher()) {
            final ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(scanContext.getScanMode()).build();
            BleScanCallback callbackL = CallbacksL.newCallback(scanCallback);
            return new AbstractScanConfigurationL(scanContext, callbackL){

                @Override
                public ScanSettings getScanSettings() {
                    return scanSettings;
                }
            };
        }
        return new AbstractScanConfiguration(scanContext, scanCallback){};
    }

    static ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
        return ScanCompat.isLollipopOrHigher() ? new ScanController.Builder().setScanPeriod(configuration.getScanContext().getScanPeriod()).setScanActiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration)).setScanPassiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration)).setForceScanScheduler(forceScanScheduler).build() : new ScanController.Builder().setScanActiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration)).setScanPassiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration)).setScanPeriod(configuration.getScanContext().getScanPeriod()).setForceScanScheduler(forceScanScheduler).build();
    }

    static ForceScanScheduler createForceScanScheduler(ScanConfiguration configuration) {
        ScanContext scanContext = configuration.getScanContext();
        if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
            return ForceScanScheduler.DISABLED;
        }
        if (ScanCompat.isLollipopOrHigher()) {
            return new ForceScanScheduler(RunnersL.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
        }
        return new ForceScanScheduler(Runners.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
    }

    @TargetApi(value=18)
    static void onScanStart(ScanConfiguration configuration) {
        if (ScanCompat.isLollipopOrHigher()) {
            ScanConfigurationL scanConfiguration = (ScanConfigurationL)configuration;
            ScanSettings scanSettings = scanConfiguration.getScanSettings();
            ScanCallback scanCallback = (ScanCallback)scanConfiguration.getScanCallback();
            BluetoothLeScanner scanner = ScanCompat.getScanner();
            if (scanner != null) {
                scanner.startScan(EMPTY_SCAN_FILTERS, scanSettings, scanCallback);
            } else {
                Logger.e((String)"onRangingStart(): BluetoothLeScanner is null.");
            }
        } else {
            BleScanCallback scanCallback = configuration.getScanCallback();
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null) {
                adapter.startLeScan((BluetoothAdapter.LeScanCallback)scanCallback);
            } else {
                Logger.d((String)"Scan start requested but Bluetooth Adapter is null.");
            }
        }
    }

    static void onScanStop(BleScanCallback callback) {
        if (ScanCompat.isLollipopOrHigher()) {
            if (callback != null) {
                ScanCallback scanCallback = (ScanCallback)callback;
                BluetoothLeScanner scanner = ScanCompat.getScanner();
                if (scanner != null) {
                    scanner.flushPendingScanResults(scanCallback);
                    scanner.stopScan(scanCallback);
                }
            }
        } else {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null) {
                adapter.stopLeScan((BluetoothAdapter.LeScanCallback)callback);
            }
        }
    }

    @TargetApi(value=21)
    private static BluetoothLeScanner getScanner() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            return adapter.getBluetoothLeScanner();
        }
        return null;
    }

    private static boolean isLollipopOrHigher() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private static abstract class AbstractScanConfigurationL
    extends AbstractScanConfiguration
    implements ScanConfigurationL {
        protected AbstractScanConfigurationL(ScanContext scanContext, BleScanCallback scanCallback) {
            super(scanContext, scanCallback);
        }
    }

    private static abstract class AbstractScanConfiguration
    implements ScanConfiguration {
        private final ScanContext scanContext;
        private final BleScanCallback scanCallback;

        protected AbstractScanConfiguration(ScanContext scanContext, BleScanCallback scanCallback) {
            this.scanCallback = scanCallback;
            this.scanContext = scanContext;
        }

        @Override
        public BleScanCallback getScanCallback() {
            return this.scanCallback;
        }

        @Override
        public void addListener(ProximityManager.ProximityListener proximityListener) {
            this.scanCallback.addListener(proximityListener);
        }

        @Override
        public void removeListener(ProximityManager.ProximityListener proximityListener) {
            this.scanCallback.removeListener(proximityListener);
        }

        @Override
        public void close() throws IOException {
            this.scanCallback.close();
        }

        @Override
        public ScanContext getScanContext() {
            return this.scanContext;
        }
    }
}

