/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import com.kontakt.sdk.android.common.log.Logger;
import java.util.concurrent.ThreadFactory;

class ForceScanScheduler {
    static final ForceScanScheduler DISABLED = new ForceScanScheduler(null);
    private static final String FORCE_SCAN_THREAD_TAG = "force-scan-thread";
    private static final ThreadFactory FORCE_SCAN_THREAD_FACTORY = new ForceScanThreadFactory();
    private final Runnable forceScanRunner;
    private Thread forceScanThread;
    private State state;

    ForceScanScheduler(Runnable forceScanRunner) {
        this.forceScanRunner = forceScanRunner;
        this.state = State.READY;
    }

    synchronized void start() {
        if (!this.isEnabled()) {
            Logger.d((String)"ForceScanController not enabled");
            return;
        }
        if (this.isRunning()) {
            Logger.d((String)"ForceScanController already running");
            return;
        }
        if (this.isReady()) {
            this.forceScanThread = FORCE_SCAN_THREAD_FACTORY.newThread(this.forceScanRunner);
            this.forceScanThread.start();
            this.setState(State.RUNNING);
        }
    }

    synchronized void stop() {
        if (!this.isEnabled()) {
            Logger.d((String)"ForceScanController not enabled");
            return;
        }
        if (this.isRunning()) {
            this.forceScanThread.interrupt();
            this.forceScanThread = null;
            this.setState(State.READY);
        }
    }

    synchronized void finish() {
        if (!this.isEnabled()) {
            Logger.d((String)"ForceScanController not enabled");
            return;
        }
        if (!this.isFinished()) {
            if (this.forceScanThread != null) {
                this.forceScanThread.interrupt();
                this.forceScanThread = null;
            }
            this.setState(State.FINISHED);
        }
    }

    synchronized boolean isRunning() {
        return this.state == State.RUNNING;
    }

    synchronized boolean isFinished() {
        return this.state == State.FINISHED;
    }

    synchronized boolean isReady() {
        return this.state == State.READY;
    }

    boolean isEnabled() {
        return this.forceScanRunner != null;
    }

    private void setState(State state) {
        this.state = state;
    }

    private static class ForceScanThreadFactory
    implements ThreadFactory,
    Thread.UncaughtExceptionHandler {
        private ForceScanThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, ForceScanScheduler.FORCE_SCAN_THREAD_TAG);
            thread.setUncaughtExceptionHandler(this);
            return thread;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            Logger.d((String)String.format("Force scan interrupted. Exception swallowed.", new Object[0]));
        }
    }

    private static enum State {
        READY,
        RUNNING,
        FINISHED;

    }
}

