/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDiscoverer;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDiscoverer;
import java.util.Collection;
import java.util.LinkedList;

final class DefaultBluetoothDeviceDiscoverer
implements BluetoothDeviceDiscoverer {
    private final Collection<BluetoothDeviceDiscoverer> discoverers = new LinkedList<BluetoothDeviceDiscoverer>();

    DefaultBluetoothDeviceDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract) {
        EddystoneScanContext eddystoneScanContext;
        ActivityCheckConfiguration activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        IBeaconScanContext iBeaconScanContext = scanContext.getIBeaconScanContext();
        if (iBeaconScanContext != null) {
            this.discoverers.add(new IBeaconDiscoverer(iBeaconScanContext, activityCheckConfiguration, discoveryContract));
        }
        if ((eddystoneScanContext = scanContext.getEddystoneScanContext()) != null) {
            this.discoverers.add(new EddystoneDiscoverer(eddystoneScanContext, activityCheckConfiguration, discoveryContract));
        }
    }

    @Override
    public boolean performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanResult) {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            if (!discoverer.performDiscovery(bluetoothDevice, rssi, scanResult)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearResources() {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            discoverer.clearResources();
        }
    }

    @Override
    public void disable() {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            discoverer.disable();
        }
    }

    @Override
    public void reset() {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            discoverer.reset();
        }
    }

    @Override
    public synchronized void evictInactiveDevices() {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            discoverer.evictInactiveDevices();
        }
    }
}

