/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.rssi;

import com.kontakt.sdk.android.ble.math.Mean;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;

public final class LimitedMeanRssiCalculator
implements RssiCalculator {
    private static final Mean MEAN = new Mean();
    private final Map<Integer, Queue<Double>> rssiMapLog = new WeakHashMap<Integer, Queue<Double>>();
    private final int logSize;

    LimitedMeanRssiCalculator(int logSize) {
        this.logSize = logSize;
    }

    @Override
    public double calculateRssi(int uniqueKey, int rssi) {
        Queue<Double> rssiQueue = this.rssiMapLog.get(uniqueKey);
        if (rssiQueue == null) {
            rssiQueue = new LinkedList<Double>();
            this.rssiMapLog.put(uniqueKey, rssiQueue);
        }
        if (rssiQueue.size() >= this.logSize) {
            rssiQueue.poll();
        }
        rssiQueue.add(Double.valueOf(rssi));
        return MEAN.evaluate(ConversionUtils.toPrimitive((Double[])rssiQueue.toArray(new Double[rssiQueue.size()])));
    }

    @Override
    public void clear() {
        this.rssiMapLog.clear();
    }

    @Override
    public void clear(int uniqueKey) {
        this.rssiMapLog.remove(uniqueKey);
    }
}

