/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.math;

import com.kontakt.sdk.android.ble.math.AbstractStorelessUnivariateStatistic;
import java.io.Serializable;

public final class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8231831954703408316L;
    private long n = 0L;
    private double value = 0.0;

    @Override
    public void increment(double d) {
        this.value += d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values, begin, length, true)) {
            sum = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sum += values[i];
            }
        }
        return sum;
    }

    public double evaluate(double[] values, double[] weights, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values, weights, begin, length, true)) {
            sum = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sum += values[i] * weights[i];
            }
        }
        return sum;
    }

    public double evaluate(double[] values, double[] weights) {
        return this.evaluate(values, weights, 0, values.length);
    }
}

