/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.filter.eddystone;

import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneUIDAdvertisingPacket;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneURLAdvertisingPacket;
import com.kontakt.sdk.android.ble.filter.eddystone.UIDFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.URLFilter;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class EddystoneFilters {
    private EddystoneFilters() {
    }

    public static UIDFilter newUIDFilter(final String namespaceId, final String instanceId) {
        SDKPreconditions.checkNotNull((Object)namespaceId, (Object)"Namespace Id is null");
        SDKPreconditions.checkNotNull((Object)instanceId, (Object)"Instance Id is null");
        return new UIDFilter(){

            public boolean apply(EddystoneUIDAdvertisingPacket uidPacket) {
                return uidPacket.getNamespaceId().equals(namespaceId) && uidPacket.getInstanceId().equals(instanceId);
            }
        };
    }

    public static URLFilter newURLFilter(final String url) {
        SDKPreconditions.checkNotNull((Object)url, (Object)"URL is null");
        return new URLFilter(){

            public boolean apply(EddystoneURLAdvertisingPacket eddystonePacket) {
                return eddystonePacket.getUrl().equals(url);
            }
        };
    }

    public static UIDFilter newNamespaceIdFilter(final String namespaceId) {
        SDKPreconditions.checkNotNull((Object)namespaceId, (Object)"Namespace id is null");
        return new UIDFilter(){

            public boolean apply(EddystoneUIDAdvertisingPacket eddystoneUIDAdvertisingPacket) {
                return eddystoneUIDAdvertisingPacket.getNamespaceId().equals(namespaceId);
            }
        };
    }

    public static UIDFilter newInstanceIdFilter(final String instanceId) {
        SDKPreconditions.checkNotNull((Object)instanceId, (Object)"Instance id is null");
        return new UIDFilter(){

            public boolean apply(EddystoneUIDAdvertisingPacket eddystoneUIDAdvertisingPacket) {
                return eddystoneUIDAdvertisingPacket.getInstanceId().equals(instanceId);
            }
        };
    }
}

