/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.bluetooth.BluetoothDevice;
import android.util.SparseArray;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.discovery.DiscoveryUtils;
import com.kontakt.sdk.android.ble.discovery.ScanResponse;
import com.kontakt.sdk.android.ble.discovery.ibeacon.AdvertisingPacketImpl;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.util.LimitedLinkedHashMap;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class IBeaconAdvertisingDataController {
    public static final int TYPE_MANUFACTURER_SPECIFIC_DATA = 255;
    public static final int TX_POWER_BLOCK = 10;
    private static final byte[] MANUFACTURER_DATA_IBEACON_PREFIX = new byte[]{76, 0, 2, 21};
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int CACHE_SIZE = 20;
    private static final int SERVICE_UUID_MSB = 13;
    private static final int SERVICE_UUID_LSB = -48;
    private static final int MANUFACTURER_BLOCK_LENGTH = 25;
    private static final int COMPANY_ID = -3;
    private static final int COMPANY_ID_BEGIN = 1;
    private static final int PAYLOAD_VERSION_1 = 1;
    private final Map<Integer, AdvertisingPacketImpl> cache;
    private final HashCodeBuilder hashCodeBuilder;
    private AdvertisingPacketImpl.Builder builder;
    private RssiCalculator rssiCalculator;
    private Collection<IBeaconFilter> filters;
    private boolean isEnabled;

    public IBeaconAdvertisingDataController(IBeaconScanContext scanContext) {
        this.rssiCalculator = scanContext.getRssiCalculator();
        this.filters = scanContext.getFilters();
        this.isEnabled = true;
        this.hashCodeBuilder = HashCodeBuilder.init();
        this.builder = new AdvertisingPacketImpl.Builder();
        this.cache = new LimitedLinkedHashMap<Integer, AdvertisingPacketImpl>(20);
    }

    public static SparseArray<byte[]> parseScanRecord(byte[] scanRecord) {
        boolean shuffled;
        SparseArray<byte[]> frameArray = DiscoveryUtils.extractMetaData(scanRecord);
        byte[] manufacturerData = (byte[])frameArray.get(255, (Object)EMPTY_BYTE_ARRAY);
        byte[] serviceData = (byte[])frameArray.get(22, (Object)EMPTY_BYTE_ARRAY);
        boolean standard = ConversionUtils.doesArrayBeginWith((byte[])manufacturerData, (byte[])MANUFACTURER_DATA_IBEACON_PREFIX) && manufacturerData.length >= 25 && serviceData.length == 9 && serviceData[0] == 13 && serviceData[1] == -48;
        boolean bl = shuffled = ConversionUtils.doesArrayBeginWith((byte[])manufacturerData, (byte[])MANUFACTURER_DATA_IBEACON_PREFIX) && serviceData.length >= 25 && serviceData[0] == 13 && serviceData[1] == -48 && serviceData[2] == 1;
        if (standard || shuffled) {
            return frameArray;
        }
        return null;
    }

    public IBeaconAdvertisingPacket getOrCreateAdvertisingPackage(BluetoothDevice device, int rssi, SparseArray<byte[]> parsedScan) {
        int deviceHashCode = this.hashCodeBuilder.append((Object)device.getAddress()).append((byte[])parsedScan.get(255)).build();
        AdvertisingPacketImpl advertisingPackage = this.cache.get(deviceHashCode);
        if (advertisingPackage != null) {
            this.update(advertisingPackage, parsedScan, deviceHashCode, rssi);
            return advertisingPackage;
        }
        byte[] manufacturerData = (byte[])parsedScan.get(255);
        byte txPower = manufacturerData[24];
        double rssiValue = this.rssiCalculator.calculateRssi(deviceHashCode, rssi);
        byte[] serviceData = (byte[])parsedScan.get(22);
        ScanResponse scanResponse = ScanResponse.fromScanResponseBytes(serviceData);
        double distance = DiscoveryUtils.calculateDistance(txPower, rssiValue);
        UUID proximityUUID = ConversionUtils.toUUID((byte[])Arrays.copyOfRange(manufacturerData, 4, 20));
        int major = ConversionUtils.asInt((byte[])Arrays.copyOfRange(manufacturerData, 20, 22));
        int minor = ConversionUtils.asInt((byte[])Arrays.copyOfRange(manufacturerData, 22, 24));
        advertisingPackage = this.builder.setAdvertisingData(parsedScan).setRssi(rssi).setProximityUUID(proximityUUID).setMajor(major).setMinor(minor).setBeaconUniqueId(scanResponse.getUniqueId()).setFirmwareVersion(scanResponse.getFirmwareVersion()).setBatteryPercentagePower(scanResponse.getBatteryPower()).setShuffled(scanResponse.isShuffled()).setAddress(device.getAddress()).setName(device.getName()).setTxPower(txPower).setDistance(distance).setProximity(Proximity.fromDistance((double)distance)).setTimestamp(System.currentTimeMillis()).build();
        this.cache.put(deviceHashCode, advertisingPackage);
        return advertisingPackage;
    }

    private void update(AdvertisingPacketImpl advertisingPacket, SparseArray<byte[]> advertisingData, int deviceHashCode, int rssi) {
        double rssiValue = this.rssiCalculator.calculateRssi(deviceHashCode, rssi);
        byte txPower = ((byte[])advertisingData.get(255))[24];
        double distance = DiscoveryUtils.calculateDistance(txPower, rssiValue);
        advertisingPacket.setDistance(distance);
        advertisingPacket.setRssi(rssiValue);
        advertisingPacket.setProximity(Proximity.fromDistance((double)distance));
        advertisingPacket.setTimestamp(System.currentTimeMillis());
    }

    public boolean filter(IBeaconAdvertisingPacket advertisingPacket) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (IBeaconFilter filter : this.filters) {
            if (!filter.apply(advertisingPacket)) continue;
            return true;
        }
        return false;
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
            this.cache.clear();
            this.filters = Collections.emptyList();
            this.rssiCalculator.clear();
            this.rssiCalculator = null;
        }
    }

    void clearRssiCalculation(int deviceHashCode) {
        if (this.rssiCalculator != null) {
            this.rssiCalculator.clear(deviceHashCode);
        }
    }
}

