/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.util.SparseArray;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystonePropertyResolver;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class URLResolver
implements EddystonePropertyResolver<String> {
    private static final SparseArray<String> URL_SCHEME_PREFIXES = new SparseArray(4);
    private static final SparseArray<String> URL_SCHEME_SUFFIXES;
    private static final int SCAN_RECORD_EDDYSTONE_PDU_LENGTH_INDEX = 7;
    static final int SCAN_RECORD_EDDYSTONE_URL_START_INDEX = 13;
    private static final int URL_PREFIX_MASK = 15;
    private static final int URL_SUFFIX_MASK = 15;
    private final StringBuilder urlBuilder = new StringBuilder();

    URLResolver() {
    }

    @Override
    public byte[] extract(byte[] scanRecord) {
        int urlLength = scanRecord[7] - 5;
        return ConversionUtils.extractPayload((byte[])scanRecord, (int)13, (int)urlLength);
    }

    @Override
    public String parse(byte[] source) {
        if (source == null) {
            return null;
        }
        this.urlBuilder.setLength(0);
        int prefix = source[0] & 0xF;
        this.urlBuilder.append((String)URL_SCHEME_PREFIXES.get(prefix));
        int size = source.length - 1;
        for (int i = 1; i < size; ++i) {
            this.urlBuilder.append((char)source[i]);
        }
        String urlSuffix = (String)URL_SCHEME_SUFFIXES.get(source[source.length - 1] & 0xF);
        if (urlSuffix != null) {
            this.urlBuilder.append(urlSuffix);
        }
        return this.urlBuilder.toString();
    }

    static {
        URL_SCHEME_PREFIXES.put(0, (Object)"http://www.");
        URL_SCHEME_PREFIXES.put(1, (Object)"https://www.");
        URL_SCHEME_PREFIXES.put(2, (Object)"http://");
        URL_SCHEME_PREFIXES.put(3, (Object)"https://");
        URL_SCHEME_SUFFIXES = new SparseArray(13);
        URL_SCHEME_SUFFIXES.put(1, (Object)".com/");
        URL_SCHEME_SUFFIXES.put(2, (Object)".org/");
        URL_SCHEME_SUFFIXES.put(3, (Object)".edu/");
        URL_SCHEME_SUFFIXES.put(4, (Object)".net/");
        URL_SCHEME_SUFFIXES.put(5, (Object)".info/");
        URL_SCHEME_SUFFIXES.put(6, (Object)".biz/");
        URL_SCHEME_SUFFIXES.put(7, (Object)".gov/");
        URL_SCHEME_SUFFIXES.put(8, (Object)".org");
        URL_SCHEME_SUFFIXES.put(9, (Object)".edu");
        URL_SCHEME_SUFFIXES.put(10, (Object)".net");
        URL_SCHEME_SUFFIXES.put(11, (Object)".info");
        URL_SCHEME_SUFFIXES.put(12, (Object)".biz");
        URL_SCHEME_SUFFIXES.put(13, (Object)".gov");
    }
}

