/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.eddystone.EddystonePropertyResolver;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class TLMResolver
implements EddystonePropertyResolver<Telemetry> {
    static final int TLM_START_INDEX = 12;
    private static final int SCAN_RECORD_TLM_LENGTH = 13;

    TLMResolver() {
    }

    @Override
    public byte[] extract(byte[] scanRecord) {
        return ConversionUtils.extractPayload((byte[])scanRecord, (int)12, (int)13);
    }

    @Override
    public Telemetry parse(byte[] source) {
        if (source == null) {
            return null;
        }
        int version = source[0] & 0xFF;
        byte[] batteryVoltage = new byte[]{source[1], source[2]};
        int batteryVoltageValue = ConversionUtils.asInt((byte[])batteryVoltage);
        byte[] tempVoltage = new byte[]{source[3], source[4]};
        double tempVoltageValue = (double)ConversionUtils.asInt((byte[])tempVoltage) * 1.0 / 256.0;
        byte[] advertisingPduCount = new byte[]{source[5], source[6], source[7], source[8]};
        int advertisingPduCountValue = ConversionUtils.asInt((byte[])advertisingPduCount);
        byte[] timeSincePowerUp = new byte[]{source[9], source[10], source[11], source[12]};
        int timeSincePowerUpValue = ConversionUtils.asInt((byte[])timeSincePowerUp) / 10;
        return new Telemetry.Builder().setBatteryVoltage(batteryVoltageValue).setTemperature(tempVoltageValue).setTimeSincePowerUp(timeSincePowerUpValue).setPduCount(advertisingPduCountValue).setVersion(version).build();
    }
}

