/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.eddystone.EddystonePropertyResolver;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class NamespaceIdResolver
implements EddystonePropertyResolver<String> {
    static final int NAMESPACE_ID_START_INDEX = 13;
    private static final int NAMESPACE_ID_LENGTH = 10;
    private static final int MASK = 255;
    private static final String FORMAT = "%02x";
    private final StringBuilder namespaceIdBuilder = new StringBuilder();

    NamespaceIdResolver() {
    }

    @Override
    public byte[] extract(byte[] scanRecord) {
        return ConversionUtils.extractPayload((byte[])scanRecord, (int)13, (int)10);
    }

    @Override
    public String parse(byte[] source) {
        if (source == null) {
            return null;
        }
        this.namespaceIdBuilder.setLength(0);
        for (byte byteValue : source) {
            this.namespaceIdBuilder.append(String.format(FORMAT, byteValue & 0xFF));
        }
        return this.namespaceIdBuilder.toString();
    }
}

