/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.bluetooth.BluetoothDevice;
import android.util.SparseIntArray;
import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.device.EddystoneDevice;
import com.kontakt.sdk.android.ble.discovery.DiscoveryUtils;
import com.kontakt.sdk.android.ble.discovery.ScanResponse;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneTLMAdvertisingPacket;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneUIDAdvertisingPacket;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneURLAdvertisingPacket;
import com.kontakt.sdk.android.ble.discovery.eddystone.InstanceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.NamespaceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.TLMResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.URLResolver;
import com.kontakt.sdk.android.ble.filter.eddystone.TLMFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.UIDFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.URLFilter;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.ble.util.LimitedLinkedHashMap;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import java.util.Collection;
import java.util.Map;

final class EddystoneAdvertisingDataController {
    private static final int HEADER_LENGTH = 12;
    private static final int HEADER_BLE_FLAGS_LENGTH_OF_FLAGS_BLOCK = 2;
    private static final int HEADER_BLE_FLAGS_PDU_DATA_TYPE = 1;
    private static final int HEADER_BLE_FLAGS_DATA = 6;
    private static final int HEADER_SERVICE_UUID_LENGTH_OF_SERVICE_UUID_BLOCK = 3;
    private static final int HEADER_SERVICE_UUID_PDU_DATA_TYPE = 3;
    private static final byte HEADER_SERVICE_UUID_HIGH_ORDER_VALUE = -86;
    private static final byte HEADER_SERVICE_UUID_LOW_ORDER_VALUE = -2;
    private static final int SCAN_RECORD_TX_POWER_INDEX = 12;
    private static final int CACHE_SIZE = 10;
    private static final InstanceIdResolver INSTANCE_ID_RESOLVER = new InstanceIdResolver();
    private static final NamespaceIdResolver NAMESPACE_ID_RESOLVER = new NamespaceIdResolver();
    private static final TLMResolver TLM_RESOLVER = new TLMResolver();
    private static final URLResolver URL_RESOLVER = new URLResolver();
    private static byte[] EDDYSTONE_SPECIFIC_HEADER = new byte[]{2, 1, 6, 3, 3, -86, -2};
    private final Map<String, UIDAdvertisingPacket> UID_CACHE = new LimitedLinkedHashMap<String, UIDAdvertisingPacket>(10);
    private final Map<String, TLMAdvertisingPacket> TLM_CACHE = new LimitedLinkedHashMap<String, TLMAdvertisingPacket>(10);
    private final Map<String, URLAdvertisingPacket> URL_CACHE = new LimitedLinkedHashMap<String, URLAdvertisingPacket>(10);
    private final Map<String, EddystoneDevice> BUILT_DEVICES_CACHE;
    private final Map<String, ScanResponse> SCAN_RESPONSE_CACHE = new LimitedLinkedHashMap<String, ScanResponse>(10);
    private final SparseIntArray TX_POWER_CACHE;
    private boolean isEnabled = true;
    private final Collection<UIDFilter> uidFilters;
    private final boolean areUIDFiltersEmpty;
    private final Collection<TLMFilter> tlmFilters;
    private final boolean areTLMFiltersEmpty;
    private final Collection<URLFilter> urlFilters;
    private final boolean areURLFiltersEmpty;
    private final RssiCalculator rssiCalculator;
    private final Collection<EddystoneFrameType> triggerFrameTypes;

    static boolean isEddystoneSpecificFrame(byte[] scanRecord) {
        return scanRecord != null && scanRecord.length >= 12 && ConversionUtils.doesArrayBeginWith((byte[])scanRecord, (byte[])EDDYSTONE_SPECIFIC_HEADER) && scanRecord[9] == -86 && scanRecord[10] == -2;
    }

    EddystoneAdvertisingDataController(EddystoneScanContext scanContext) {
        this.BUILT_DEVICES_CACHE = new LimitedLinkedHashMap<String, EddystoneDevice>(10);
        this.TX_POWER_CACHE = new SparseIntArray();
        this.uidFilters = scanContext.getUIDFilters();
        this.areUIDFiltersEmpty = this.uidFilters.isEmpty();
        this.tlmFilters = scanContext.getTLMFilters();
        this.areTLMFiltersEmpty = this.tlmFilters.isEmpty();
        this.urlFilters = scanContext.getURLFilters();
        this.areURLFiltersEmpty = this.urlFilters.isEmpty();
        this.rssiCalculator = scanContext.getRssiCalculator();
        this.triggerFrameTypes = scanContext.getTriggerFrameTypes();
    }

    void cacheUID(String deviceAddress, byte[] scanResult) {
        boolean isInstanceChanged;
        this.updateTxPower(deviceAddress, scanResult[12]);
        UIDAdvertisingPacket eddystoneUIDPacket = (UIDAdvertisingPacket)this.getUIDAdvertisingPacket(deviceAddress);
        boolean isNewUIDPacket = eddystoneUIDPacket == null;
        boolean isNamespaceChanged = !isNewUIDPacket && !ConversionUtils.doesArrayContainSubset((byte[])scanResult, (byte[])eddystoneUIDPacket.getNamespaceIdBytes(), (int)13);
        boolean bl = isInstanceChanged = !isNewUIDPacket && !ConversionUtils.doesArrayContainSubset((byte[])scanResult, (byte[])eddystoneUIDPacket.getInstanceIdBytes(), (int)23);
        if (isNewUIDPacket) {
            this.putUIDAdvertisingPacket(deviceAddress, new UIDAdvertisingPacket(scanResult, this.getScanResponse(deviceAddress)));
            this.resetDeviceCache(deviceAddress);
            return;
        }
        if (isNamespaceChanged) {
            eddystoneUIDPacket.swapNamespaceId(scanResult);
            this.resetDeviceCache(deviceAddress);
        }
        if (isInstanceChanged) {
            eddystoneUIDPacket.swapInstanceId(scanResult);
            this.resetDeviceCache(deviceAddress);
        }
    }

    void cacheUrl(String deviceAddress, byte[] scanResult) {
        boolean isUrlChanged;
        this.updateTxPower(deviceAddress, scanResult[12]);
        URLAdvertisingPacket urlAdvertisingPacket = (URLAdvertisingPacket)this.getURLAdvertisingPacket(deviceAddress);
        boolean isNewUrlPacket = urlAdvertisingPacket == null;
        boolean bl = isUrlChanged = !isNewUrlPacket && !ConversionUtils.doesArrayContainSubset((byte[])scanResult, (byte[])urlAdvertisingPacket.getUrlBytes(), (int)13);
        if (isNewUrlPacket) {
            this.putURLAdvertisingPacket(deviceAddress, new URLAdvertisingPacket(scanResult));
            return;
        }
        if (isUrlChanged) {
            urlAdvertisingPacket.swap(scanResult);
            this.resetDeviceCache(deviceAddress);
        }
    }

    void cacheTelemetry(String deviceAddress, byte[] scanResult) {
        boolean isTLMChanged;
        TLMAdvertisingPacket tlmAdvertisingPacket = (TLMAdvertisingPacket)this.getTLMAdvertisingPacket(deviceAddress);
        boolean isNewTLMAdvertisingPacket = tlmAdvertisingPacket == null;
        boolean bl = isTLMChanged = !isNewTLMAdvertisingPacket && !ConversionUtils.doesArrayContainSubset((byte[])scanResult, (byte[])tlmAdvertisingPacket.getTLMBytes(), (int)12);
        if (isNewTLMAdvertisingPacket) {
            this.putTLMAdvertisingPacket(deviceAddress, new TLMAdvertisingPacket(scanResult));
            return;
        }
        if (isTLMChanged) {
            tlmAdvertisingPacket.swap(scanResult);
            this.resetDeviceCache(deviceAddress);
        }
    }

    void cacheScanResponse(String deviceAddress, byte[] scanResult) {
        if (!this.SCAN_RESPONSE_CACHE.containsKey(deviceAddress)) {
            ScanResponse scanResponse = ScanResponse.fromScanRecordBytes(scanResult);
            this.SCAN_RESPONSE_CACHE.put(deviceAddress, scanResponse);
        }
    }

    void disable() {
        this.isEnabled = false;
    }

    void clearResources() {
        this.UID_CACHE.clear();
        this.TLM_CACHE.clear();
        this.BUILT_DEVICES_CACHE.clear();
        this.URL_CACHE.clear();
        this.SCAN_RESPONSE_CACHE.clear();
        this.TX_POWER_CACHE.clear();
        this.rssiCalculator.clear();
    }

    void cacheProperty(EddystoneFrameType frameType, String deviceAddress, byte[] scanResult) {
        switch (frameType) {
            case UID: {
                this.cacheScanResponse(deviceAddress, scanResult);
                this.cacheUID(deviceAddress, scanResult);
                break;
            }
            case URL: {
                this.cacheUrl(deviceAddress, scanResult);
                break;
            }
            case TLM: {
                this.cacheTelemetry(deviceAddress, scanResult);
                break;
            }
            default: {
                Logger.e((String)("Unknown Eddystone frame type parsed for device with address: " + deviceAddress));
            }
        }
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    EddystoneDevice getOrCreateDevice(BluetoothDevice bluetoothDevice, int rssi) {
        String deviceAddress = bluetoothDevice.getAddress();
        EddystoneDevice eddystoneDevice = this.getEddystoneDevice(deviceAddress);
        if (!this.areTriggerFramesCached(deviceAddress)) {
            return null;
        }
        int txPower = this.getTxPower(deviceAddress.hashCode());
        double rssiValue = this.rssiCalculator.calculateRssi(deviceAddress.hashCode(), rssi);
        double distance = DiscoveryUtils.calculateDistance(txPower, rssiValue);
        Proximity proximity = Proximity.fromDistance((double)distance);
        if (eddystoneDevice == null) {
            String name = bluetoothDevice.getName();
            EddystoneUIDAdvertisingPacket uidPacket = this.getUIDAdvertisingPacket(deviceAddress);
            EddystoneTLMAdvertisingPacket tlmPacket = this.getTLMAdvertisingPacket(deviceAddress);
            EddystoneURLAdvertisingPacket urlPacket = this.getURLAdvertisingPacket(deviceAddress);
            ScanResponse scanResponse = this.getScanResponse(deviceAddress);
            eddystoneDevice = new EddystoneDevice.Builder().setName(name).setTxPower(txPower).setTLMAdvertisingPacket(tlmPacket).setUIDAdvertisingPacket(uidPacket).setURLAdvertisingPacket(urlPacket).setTxPower(txPower).setDistance(distance).setAddress(deviceAddress).setProximity(proximity).setUniqueId(scanResponse.getUniqueId()).setFirmwareVersion(scanResponse.getFirmwareVersion()).setBatteryPower(scanResponse.getBatteryPower()).setShuffled(scanResponse.isShuffled()).setRssi(rssiValue).setTimestamp(System.currentTimeMillis()).build();
        } else {
            eddystoneDevice = new EddystoneDevice.Builder().setEddystoneDevice(eddystoneDevice).setDistance(distance).setRssi(rssi).setProximity(proximity).setTimestamp(System.currentTimeMillis()).build();
        }
        this.putEddystoneDevice(deviceAddress, eddystoneDevice);
        return eddystoneDevice;
    }

    boolean areTriggerFramesCached(String deviceAddress) {
        boolean isURLCached;
        boolean isUIDCached;
        boolean bl = isUIDCached = this.getUIDAdvertisingPacket(deviceAddress) != null;
        if (this.triggerFrameTypes.contains((Object)EddystoneFrameType.UID) && !isUIDCached) {
            return false;
        }
        boolean bl2 = isURLCached = this.getURLAdvertisingPacket(deviceAddress) != null;
        if (this.triggerFrameTypes.contains((Object)EddystoneFrameType.URL) && !isURLCached) {
            return false;
        }
        boolean isTLMCached = this.getTLMAdvertisingPacket(deviceAddress) != null;
        return !this.triggerFrameTypes.contains((Object)EddystoneFrameType.TLM) || isTLMCached;
    }

    void clearRssiCalculation(int key) {
        this.rssiCalculator.clear(key);
    }

    boolean filter(String deviceAddress) {
        if (this.areUIDFiltersEmpty && this.areURLFiltersEmpty && this.areTLMFiltersEmpty) {
            return true;
        }
        EddystoneUIDAdvertisingPacket uidPacket = this.getUIDAdvertisingPacket(deviceAddress);
        if (!this.areUIDFiltersEmpty && uidPacket != null) {
            for (UIDFilter uIDFilter : this.uidFilters) {
                if (!uIDFilter.apply(uidPacket)) continue;
                return true;
            }
        }
        EddystoneURLAdvertisingPacket urlPacket = this.getURLAdvertisingPacket(deviceAddress);
        if (!this.areURLFiltersEmpty && urlPacket != null) {
            for (URLFilter urlFilter : this.urlFilters) {
                if (!urlFilter.apply(urlPacket)) continue;
                return true;
            }
        }
        EddystoneTLMAdvertisingPacket eddystoneTLMAdvertisingPacket = this.getTLMAdvertisingPacket(deviceAddress);
        if (!this.areTLMFiltersEmpty && eddystoneTLMAdvertisingPacket != null) {
            for (TLMFilter tlmFilter : this.tlmFilters) {
                if (!tlmFilter.apply(eddystoneTLMAdvertisingPacket)) continue;
                return true;
            }
        }
        return false;
    }

    EddystoneUIDAdvertisingPacket getNamespaceIfAllTriggersAreSatisfied(String deviceAddress) {
        if (this.areTriggerFramesCached(deviceAddress)) {
            return this.getUIDAdvertisingPacket(deviceAddress);
        }
        return null;
    }

    ScanResponse getScanResponse(String deviceAddress) {
        return this.SCAN_RESPONSE_CACHE.get(deviceAddress);
    }

    EddystoneUIDAdvertisingPacket getUIDAdvertisingPacket(String deviceAddress) {
        return this.UID_CACHE.get(deviceAddress);
    }

    EddystoneURLAdvertisingPacket getURLAdvertisingPacket(String deviceAddress) {
        return this.URL_CACHE.get(deviceAddress);
    }

    EddystoneTLMAdvertisingPacket getTLMAdvertisingPacket(String deviceAddress) {
        return this.TLM_CACHE.get(deviceAddress);
    }

    EddystoneDevice getEddystoneDevice(String deviceAddress) {
        return this.BUILT_DEVICES_CACHE.get(deviceAddress);
    }

    int getTxPowerCacheSize() {
        return this.TX_POWER_CACHE.size();
    }

    int getTxPower(int deviceAddressHashCode) {
        return this.TX_POWER_CACHE.get(deviceAddressHashCode);
    }

    private void putUIDAdvertisingPacket(String deviceAddress, UIDAdvertisingPacket uidAdvertisingPacket) {
        this.UID_CACHE.put(deviceAddress, uidAdvertisingPacket);
    }

    private void putURLAdvertisingPacket(String deviceAddress, URLAdvertisingPacket urlAdvertisingPacket) {
        this.URL_CACHE.put(deviceAddress, urlAdvertisingPacket);
    }

    private void putTLMAdvertisingPacket(String deviceAddress, TLMAdvertisingPacket tlmAdvertisingPacket) {
        this.TLM_CACHE.put(deviceAddress, tlmAdvertisingPacket);
    }

    private void putEddystoneDevice(String address, EddystoneDevice eddystoneDevice) {
        this.BUILT_DEVICES_CACHE.put(address, eddystoneDevice);
    }

    private void updateTxPower(String deviceAddress, int txPower) {
        this.TX_POWER_CACHE.put(deviceAddress.hashCode(), txPower);
    }

    private void resetDeviceCache(String deviceAddress) {
        this.BUILT_DEVICES_CACHE.remove(deviceAddress);
    }

    private static class URLAdvertisingPacket
    implements EddystoneURLAdvertisingPacket {
        private byte[] urlBytes;
        private String url;

        private URLAdvertisingPacket(byte[] scanRecord) {
            this.swap(scanRecord);
        }

        private void swap(byte[] scanRecord) {
            this.urlBytes = URL_RESOLVER.extract(scanRecord);
            this.url = EddystoneUtils.deserializeUrl((byte[])this.urlBytes);
        }

        @Override
        public byte[] getUrlBytes() {
            return this.urlBytes;
        }

        @Override
        public String getUrl() {
            return this.url;
        }
    }

    private static class UIDAdvertisingPacket
    implements EddystoneUIDAdvertisingPacket {
        private final ScanResponse scanResponse;
        private byte[] namespaceIdBytes;
        private String namespaceId;
        private byte[] instanceIdBytes;
        private String instanceId;
        private boolean shuffled;

        private UIDAdvertisingPacket(byte[] scanRecord, ScanResponse scanResponse) {
            this.swapNamespaceId(scanRecord);
            this.swapInstanceId(scanRecord);
            this.shuffled = scanResponse.isShuffled();
            this.scanResponse = scanResponse;
        }

        private void swapNamespaceId(byte[] scanRecord) {
            this.namespaceIdBytes = NAMESPACE_ID_RESOLVER.extract(scanRecord);
            this.namespaceId = NAMESPACE_ID_RESOLVER.parse(this.namespaceIdBytes);
        }

        private void swapInstanceId(byte[] scanRecord) {
            this.instanceIdBytes = INSTANCE_ID_RESOLVER.extract(scanRecord);
            this.instanceId = INSTANCE_ID_RESOLVER.parse(this.instanceIdBytes);
        }

        @Override
        public byte[] getNamespaceIdBytes() {
            return this.namespaceIdBytes;
        }

        @Override
        public String getNamespaceId() {
            return this.namespaceId;
        }

        @Override
        public byte[] getInstanceIdBytes() {
            return this.instanceIdBytes;
        }

        @Override
        public String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getEddystoneUniqueId() {
            return this.scanResponse.getUniqueId();
        }

        @Override
        public String getFirmwareVersion() {
            return this.scanResponse.getFirmwareVersion();
        }

        @Override
        public boolean isShuffled() {
            return this.shuffled;
        }
    }

    private static class TLMAdvertisingPacket
    implements EddystoneTLMAdvertisingPacket {
        private byte[] tlmBytes;
        private Telemetry telemetry;

        private TLMAdvertisingPacket(byte[] scanRecord) {
            this.swap(scanRecord);
        }

        private void swap(byte[] scanRecord) {
            this.tlmBytes = TLM_RESOLVER.extract(scanRecord);
            this.telemetry = TLM_RESOLVER.parse(this.tlmBytes);
        }

        @Override
        public byte[] getTLMBytes() {
            return this.tlmBytes;
        }

        @Override
        public int getBatteryVoltage() {
            return this.telemetry.getBatteryVoltage();
        }

        @Override
        public double getTemperature() {
            return this.telemetry.getTemperature();
        }

        @Override
        public int getPduCount() {
            return this.telemetry.getPduCount();
        }

        @Override
        public int getTimeSincePowerUp() {
            return this.telemetry.getTimeSincePowerUp();
        }

        @Override
        public int getTelemetryVersion() {
            return this.telemetry.getVersion();
        }
    }
}

