/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBluetoothDeviceEvent
implements BluetoothDeviceEvent {
    protected static final String PARCELABLE_EVENT_TYPE = "kontakt_event_type";
    protected static final String PARCELABLE_DEVICE_LIST = "remote_device_list";
    protected static final String PARCELABLE_TIMESTAMP = "timestamp";
    protected final long timestamp;
    protected List<? extends RemoteBluetoothDevice> deviceList;
    protected final EventType eventType;
    private final DeviceProfile deviceProfile;
    private final int hashCode;

    protected AbstractBluetoothDeviceEvent(EventType eventType, DeviceProfile deviceProfile, List<? extends RemoteBluetoothDevice> deviceList, long timestamp) {
        this.eventType = eventType;
        this.deviceProfile = deviceProfile;
        this.deviceList = deviceList;
        this.timestamp = timestamp;
        this.hashCode = HashCodeBuilder.init().append((Object)eventType).append((Object)deviceProfile).append(timestamp).append(deviceList.size()).build();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public List<? extends RemoteBluetoothDevice> getDeviceList() {
        return Collections.unmodifiableList(this.deviceList);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AbstractBluetoothDeviceEvent)) {
            return false;
        }
        AbstractBluetoothDeviceEvent abstractBluetoothDeviceEvent = (AbstractBluetoothDeviceEvent)o;
        return this.eventType == abstractBluetoothDeviceEvent.eventType && this.deviceProfile == abstractBluetoothDeviceEvent.deviceProfile && this.timestamp == abstractBluetoothDeviceEvent.timestamp;
    }

    @Override
    public DeviceProfile getDeviceProfile() {
        return this.deviceProfile;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

