/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceServiceStore;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import java.io.Serializable;
import java.util.UUID;

public class KontaktDeviceCharacteristics
implements RemoteBluetoothDevice.Characteristics {
    private final UUID proximityUUID;
    private final int major;
    private final int minor;
    private final int powerLevel;
    private final long advertisingInterval;
    private final String batteryLevel;
    private final String manufacturerName;
    private final String modelName;
    private final String firmwareRevision;
    private final String hardwareRevision;
    private final DeviceProfile activeProfile;
    private final String namespaceId;
    private final String instanceId;
    private final String url;
    private final boolean secure;
    public static final Parcelable.Creator<KontaktDeviceCharacteristics> CREATOR = new Parcelable.Creator<KontaktDeviceCharacteristics>(){

        public KontaktDeviceCharacteristics createFromParcel(Parcel source) {
            return new KontaktDeviceCharacteristics(source);
        }

        public KontaktDeviceCharacteristics[] newArray(int size) {
            return new KontaktDeviceCharacteristics[size];
        }
    };

    public KontaktDeviceCharacteristics(KontaktDeviceServiceStore serviceStore) {
        String modelNameValue = null;
        try {
            modelNameValue = serviceStore.getPropagatedDeviceNameCharacteristic().getStringValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String manufacturerNameValue = null;
        try {
            manufacturerNameValue = serviceStore.getManufacturerNameCharacteristic().getStringValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String firmwareRevisionValue = null;
        try {
            firmwareRevisionValue = serviceStore.getFirmwareRevisionCharacteristic().getStringValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String hardwareRevisionValue = null;
        try {
            hardwareRevisionValue = serviceStore.getHardwareRevisionCharacteristic().getStringValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int powerLevelValue = -1;
        try {
            powerLevelValue = ConversionUtils.toPowerLevel((byte[])serviceStore.getPowerLevelCharacteristic().getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String batteryLevelValue = null;
        try {
            batteryLevelValue = String.valueOf(serviceStore.getBatteryLevelCharacteristic().getIntValue()) + "%";
        }
        catch (Exception exception) {
            // empty catch block
        }
        UUID proximityUUIDValue = null;
        try {
            proximityUUIDValue = serviceStore.getProximityCharacteristic().getUUIDValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int majorValue = -1;
        try {
            majorValue = ConversionUtils.asInt((byte[])serviceStore.getMajorCharacteristic().getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int minorValue = -1;
        try {
            minorValue = ConversionUtils.asInt((byte[])serviceStore.getMinorCharacteristic().getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        long advertisingIntervalValue = -1L;
        try {
            advertisingIntervalValue = Math.round(0.625 * (double)serviceStore.getAdvertisingIntervalCharacteristic().getLongValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DeviceProfile deviceProfile = null;
        try {
            int activeProfileValue = ConversionUtils.asInt((byte[])serviceStore.getActiveProfileCharacteristic().getValue());
            deviceProfile = DeviceProfile.getActiveProfile((int)activeProfileValue);
        }
        catch (Exception activeProfileValue) {
            // empty catch block
        }
        String namespaceId = null;
        try {
            byte[] value = serviceStore.getNamespaceIdCharacteristic().getValue();
            namespaceId = EddystoneUtils.toStringFromHex((byte[])value);
        }
        catch (Exception value) {
            // empty catch block
        }
        String instanceId = null;
        try {
            byte[] instanceBytes = serviceStore.getInstanceIdCharacteristic().getValue();
            instanceId = EddystoneUtils.toStringFromHex((byte[])instanceBytes);
        }
        catch (Exception instanceBytes) {
            // empty catch block
        }
        String url = null;
        try {
            byte[] urlBytes = serviceStore.getUrlCharacteristic().getValue();
            url = EddystoneUtils.deserializeUrl((byte[])urlBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.modelName = modelNameValue;
        this.manufacturerName = manufacturerNameValue;
        this.firmwareRevision = firmwareRevisionValue;
        this.hardwareRevision = hardwareRevisionValue;
        this.powerLevel = powerLevelValue;
        this.batteryLevel = batteryLevelValue;
        this.activeProfile = deviceProfile;
        this.advertisingInterval = advertisingIntervalValue;
        this.proximityUUID = proximityUUIDValue;
        this.major = majorValue;
        this.minor = minorValue;
        this.namespaceId = namespaceId;
        this.instanceId = instanceId;
        this.url = url;
        this.secure = serviceStore.getStoreType() == KontaktDeviceServiceStore.StoreType.SECURE;
    }

    private KontaktDeviceCharacteristics(Parcel source) {
        Bundle bundle = source.readBundle();
        this.modelName = bundle.getString("name");
        this.manufacturerName = bundle.getString("manufacturer");
        this.firmwareRevision = bundle.getString("firmware");
        this.hardwareRevision = bundle.getString("hardware");
        this.powerLevel = bundle.getInt("txPower");
        this.batteryLevel = bundle.getString("battery");
        this.advertisingInterval = bundle.getLong("interval");
        this.activeProfile = (DeviceProfile)bundle.getSerializable("activeProfile");
        this.proximityUUID = (UUID)bundle.getSerializable("proximity");
        this.major = bundle.getInt("major");
        this.minor = bundle.getInt("minor");
        this.namespaceId = bundle.getString("namespace");
        this.instanceId = bundle.getString("instanceId");
        this.url = bundle.getString("url");
        this.secure = bundle.getBoolean("secure");
    }

    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    public DeviceProfile getActiveProfile() {
        return this.activeProfile;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public long getAdvertisingInterval() {
        return this.advertisingInterval;
    }

    public String getBatteryLevel() {
        return this.batteryLevel;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getFirmwareRevision() {
        return this.firmwareRevision;
    }

    public String getHardwareRevision() {
        return this.hardwareRevision;
    }

    public String getUrl() {
        return this.url;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("proximity", (Serializable)this.proximityUUID);
        bundle.putString("name", this.modelName);
        bundle.putString("manufacturer", this.manufacturerName);
        bundle.putString("firmware", this.firmwareRevision);
        bundle.putString("hardware", this.hardwareRevision);
        bundle.putInt("txPower", this.powerLevel);
        bundle.putString("battery", this.batteryLevel);
        bundle.putInt("major", this.major);
        bundle.putInt("minor", this.minor);
        bundle.putLong("interval", this.advertisingInterval);
        bundle.putSerializable("activeProfile", (Serializable)this.activeProfile);
        bundle.putString("namespace", this.namespaceId);
        bundle.putString("instanceId", this.instanceId);
        bundle.putString("url", this.url);
        bundle.putBoolean("secure", this.secure);
        dest.writeBundle(bundle);
    }
}

