/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.BeaconId;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class BeaconDevice
implements IBeaconDevice {
    private static final String PARCEL_RSSI = "rssi";
    private static final String PARCEL_ADDRESS = "parcel_address";
    private static final String PARCEL_TIMESTAMP = "parcel_timestamp";
    private static final String PARCEL_NAME = "parcel_name";
    private static final String HASH_CODE = "hashCode";
    private static final String SHUFFLED = "shuffled";
    private final double rssi;
    private final UUID proximityUUID;
    private final int major;
    private final int minor;
    private final int txPower;
    private final String address;
    private final int hashCode;
    private final String name;
    private final String beaconUniqueId;
    private final String firmwareVersion;
    private final int batteryPower;
    private final Proximity proximity;
    private byte[] password;
    private final double accuracy;
    private final long timestamp;
    private final boolean shuffled;
    public static final Parcelable.Creator<BeaconDevice> CREATOR = new Parcelable.Creator<BeaconDevice>(){

        public BeaconDevice createFromParcel(Parcel in) {
            return new BeaconDevice(in);
        }

        public BeaconDevice[] newArray(int size) {
            return new BeaconDevice[size];
        }
    };

    public static BeaconDevice of(IBeaconDevice beaconDevice, ResolvedId resolvedId) {
        return new BeaconDevice(beaconDevice, resolvedId);
    }

    private BeaconDevice(IBeaconDevice beaconDevice, ResolvedId resolvedId) {
        BeaconId beaconId = resolvedId.getIBeaconId();
        this.proximityUUID = beaconId.getProximity();
        this.major = beaconId.getMajor();
        this.minor = beaconId.getMinor();
        this.beaconUniqueId = resolvedId.getUniqueId();
        this.txPower = beaconDevice.getTxPower();
        this.accuracy = beaconDevice.getDistance();
        this.timestamp = beaconDevice.getTimestamp();
        this.firmwareVersion = beaconDevice.getFirmwareVersion();
        this.batteryPower = beaconDevice.getBatteryPower();
        this.proximity = beaconDevice.getProximity();
        this.rssi = beaconDevice.getRssi();
        this.address = beaconDevice.getAddress();
        this.name = beaconDevice.getName();
        this.shuffled = beaconDevice.isShuffled();
        this.hashCode = HashCodeBuilder.init().append((Object)this.address).build();
    }

    public BeaconDevice(IBeaconAdvertisingPacket advertisingPacket) {
        this.proximityUUID = advertisingPacket.getProximityUUID();
        this.major = advertisingPacket.getMajor();
        this.minor = advertisingPacket.getMinor();
        this.txPower = advertisingPacket.getTxPower();
        this.accuracy = advertisingPacket.getDistance();
        this.timestamp = advertisingPacket.getTimestamp();
        this.beaconUniqueId = advertisingPacket.getBeaconUniqueId();
        this.firmwareVersion = advertisingPacket.getFirmwareVersion();
        this.batteryPower = advertisingPacket.getBatteryPercentagePower();
        this.proximity = advertisingPacket.getProximity();
        this.rssi = advertisingPacket.getRssi();
        this.address = advertisingPacket.getAddress();
        this.name = advertisingPacket.getName();
        this.shuffled = advertisingPacket.isShuffled();
        this.hashCode = HashCodeBuilder.init().append((Object)this.address).build();
    }

    private BeaconDevice(Parcel input) {
        Bundle bundle = input.readBundle(this.getClass().getClassLoader());
        this.rssi = bundle.getDouble(PARCEL_RSSI);
        this.name = bundle.getString(PARCEL_NAME);
        this.address = bundle.getString(PARCEL_ADDRESS);
        this.proximityUUID = (UUID)bundle.getSerializable("proximity");
        this.major = bundle.getInt("major");
        this.minor = bundle.getInt("minor");
        this.txPower = bundle.getInt("txPower");
        this.accuracy = bundle.getDouble("accuracy");
        this.password = bundle.getByteArray("password");
        this.timestamp = bundle.getLong(PARCEL_TIMESTAMP);
        this.proximity = Proximity.fromDistance((double)this.accuracy);
        this.firmwareVersion = bundle.getString("firmware");
        this.beaconUniqueId = bundle.getString("uniqueId");
        this.batteryPower = bundle.getInt("battery");
        this.hashCode = bundle.getInt(HASH_CODE);
        this.shuffled = bundle.getBoolean(SHUFFLED, false);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel output, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putDouble(PARCEL_RSSI, this.rssi);
        bundle.putString(PARCEL_ADDRESS, this.address);
        bundle.putString(PARCEL_NAME, this.name);
        bundle.putSerializable("proximity", (Serializable)this.proximityUUID);
        bundle.putInt("major", this.major);
        bundle.putInt("minor", this.minor);
        bundle.putInt("txPower", this.txPower);
        bundle.putDouble("accuracy", this.accuracy);
        bundle.putByteArray("password", this.password);
        bundle.putLong(PARCEL_TIMESTAMP, this.timestamp);
        bundle.putString("firmware", this.firmwareVersion);
        bundle.putString("uniqueId", this.beaconUniqueId);
        bundle.putInt("battery", this.batteryPower);
        bundle.putInt(HASH_CODE, this.hashCode);
        bundle.putBoolean(SHUFFLED, this.shuffled);
        output.writeBundle(bundle);
    }

    public int compareTo(IBeaconDevice another) {
        SDKPreconditions.checkNotNull((Object)another, (Object)"Comparing to null beacon device!");
        return Integer.valueOf(this.hashCode).compareTo(another.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BeaconDevice)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        BeaconDevice beaconDevice = (BeaconDevice)o;
        if (this.proximityUUID != null && beaconDevice.proximityUUID != null && !this.proximityUUID.equals(beaconDevice.proximityUUID)) {
            return false;
        }
        if (this.address != null && beaconDevice.address != null && !this.address.equals(beaconDevice.address)) {
            return false;
        }
        if (this.beaconUniqueId != null && beaconDevice.beaconUniqueId != null && !this.address.equals(beaconDevice.address)) {
            return false;
        }
        return this.minor == beaconDevice.minor && this.major == beaconDevice.major;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    public Proximity getProximity() {
        return this.proximity;
    }

    public int getBatteryPower() {
        return this.batteryPower;
    }

    public int getMajor() {
        return this.major;
    }

    public String getUniqueId() {
        return this.beaconUniqueId;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getTxPower() {
        return this.txPower;
    }

    public DeviceProfile getProfile() {
        return DeviceProfile.IBEACON;
    }

    public double getDistance() {
        return this.accuracy;
    }

    public String getAddress() {
        return this.address;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public double getRssi() {
        return this.rssi;
    }

    public String getName() {
        return this.name;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean isShuffled() {
        return this.shuffled;
    }
}

