/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.text.TextUtils;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.IConfig;
import com.kontakt.sdk.android.common.model.IPreset;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class KontaktDeviceBatchProcessor {
    private static final String TAG = KontaktDeviceBatchProcessor.class.getSimpleName();
    private final Batch batch;
    private final KontaktDeviceConnection kontaktDeviceConnection;
    private Map.Entry<String, Object> currentEntry = null;

    static KontaktDeviceBatchProcessor from(Batch batch, KontaktDeviceConnection connection) {
        return new KontaktDeviceBatchProcessor(batch, connection);
    }

    private KontaktDeviceBatchProcessor(Batch batch, KontaktDeviceConnection connection) {
        this.batch = batch;
        this.kontaktDeviceConnection = connection;
    }

    void process(ProcessingListener processingListener) {
        processingListener.onStart();
        Iterator argumentIterator = this.batch.processIterator();
        if (this.batch.isProcessEmpty()) {
            this.kontaktDeviceConnection.finishWriteBatch();
            processingListener.onFinish();
            return;
        }
        if (argumentIterator.hasNext()) {
            this.process(argumentIterator, processingListener);
        }
    }

    private void writeCheckNextArgument(Iterator<Map.Entry<String, Object>> argumentIterator, ProcessingListener processingListener) {
        if (argumentIterator.hasNext()) {
            argumentIterator.remove();
            this.process(argumentIterator, processingListener);
        } else {
            this.kontaktDeviceConnection.finishWriteBatch();
            processingListener.onFinish();
        }
    }

    private void writeFailure(ProcessingListener processingListener) {
        int errorCode = KontaktDeviceBatchProcessor.getErrorCode(this.currentEntry.getKey());
        Logger.e((String)(TAG + ": write operation finished with failure - error code = " + errorCode));
        processingListener.onError(KontaktDeviceBatchProcessor.getErrorCode(this.currentEntry.getKey()));
        this.performRollback(processingListener);
    }

    private void process(final Iterator<Map.Entry<String, Object>> argumentIterator, final ProcessingListener processingListener) {
        WriteListener nextWriteListener = new WriteListener(){

            @Override
            public void onWriteSuccess(WriteListener.WriteResponse response) {
                KontaktDeviceBatchProcessor.this.writeCheckNextArgument(argumentIterator, processingListener);
            }

            @Override
            public void onWriteFailure(WriteListener.Cause cause) {
                if (WriteListener.Cause.FEATURE_NOT_SUPPORTED == cause) {
                    KontaktDeviceBatchProcessor.this.writeCheckNextArgument(argumentIterator, processingListener);
                } else {
                    KontaktDeviceBatchProcessor.this.writeFailure(processingListener);
                }
            }
        };
        this.currentEntry = argumentIterator.next();
        String key = this.currentEntry.getKey();
        if (key.equals("url")) {
            this.kontaktDeviceConnection.overwriteUrl((String)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("instanceId")) {
            this.kontaktDeviceConnection.overwriteInstanceId((String)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("namespace")) {
            this.kontaktDeviceConnection.overwriteNamespaceId((String)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("proximity")) {
            this.kontaktDeviceConnection.overwriteProximityUUID((UUID)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("interval")) {
            this.kontaktDeviceConnection.overwriteAdvertisingInterval((Long)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("txPower")) {
            this.kontaktDeviceConnection.overwritePowerLevel((Integer)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("major")) {
            this.kontaktDeviceConnection.overwriteMajor((Integer)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("minor")) {
            this.kontaktDeviceConnection.overwriteMinor((Integer)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("profiles")) {
            this.kontaktDeviceConnection.switchToDeviceProfile((DeviceProfile)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("name")) {
            this.kontaktDeviceConnection.overwriteModelName((String)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("password")) {
            this.kontaktDeviceConnection.overwritePassword((String)this.currentEntry.getValue(), nextWriteListener);
        } else {
            throw new IllegalStateException("Unrecognised tag: " + key);
        }
    }

    private void performRollback(ProcessingListener processingListener) {
        this.batch.notifyProcessChanged();
        Iterator rollbackIterator = this.batch.rollbackIterator();
        if (rollbackIterator.hasNext()) {
            processingListener.onRollbackStart();
            this.processRollback(rollbackIterator, processingListener);
        }
    }

    private void processRollback(final Iterator<Map.Entry<String, Object>> argumentIterator, final ProcessingListener processingListener) {
        WriteListener nextWriteListener = new WriteListener(){

            @Override
            public void onWriteSuccess(WriteListener.WriteResponse response) {
                if (argumentIterator.hasNext()) {
                    argumentIterator.remove();
                    KontaktDeviceBatchProcessor.this.processRollback(argumentIterator, processingListener);
                } else {
                    KontaktDeviceBatchProcessor.this.kontaktDeviceConnection.finishWriteBatch();
                    processingListener.onRollbackFinish();
                }
            }

            @Override
            public void onWriteFailure(WriteListener.Cause cause) {
                Logger.d((String)"Batch not fully applied. Next write operation is required.");
                KontaktDeviceBatchProcessor.this.kontaktDeviceConnection.finishWriteBatch();
                processingListener.onRollbackError(KontaktDeviceBatchProcessor.getErrorCode((String)KontaktDeviceBatchProcessor.this.currentEntry.getKey()));
            }
        };
        this.currentEntry = argumentIterator.next();
        String key = this.currentEntry.getKey();
        if (key.equals("proximity")) {
            this.kontaktDeviceConnection.overwriteProximityUUID((UUID)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("interval")) {
            this.kontaktDeviceConnection.overwriteAdvertisingInterval((Long)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("txPower")) {
            this.kontaktDeviceConnection.overwritePowerLevel((Integer)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("major")) {
            this.kontaktDeviceConnection.overwriteMajor((Integer)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("minor")) {
            this.kontaktDeviceConnection.overwriteMinor((Integer)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("profiles")) {
            this.kontaktDeviceConnection.switchToDeviceProfile((DeviceProfile)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("name")) {
            this.kontaktDeviceConnection.overwriteModelName((String)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("namespace")) {
            this.kontaktDeviceConnection.overwriteNamespaceId((String)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("instanceId")) {
            this.kontaktDeviceConnection.overwriteInstanceId((String)this.currentEntry.getValue(), nextWriteListener);
        } else if (key.equals("url")) {
            this.kontaktDeviceConnection.overwriteUrl((String)this.currentEntry.getValue(), nextWriteListener);
        } else {
            throw new IllegalStateException("Unrecognised tag: " + key);
        }
    }

    private static int getErrorCode(String key) {
        if (key.equals("interval")) {
            return 12;
        }
        if (key.equals("proximity")) {
            return 8;
        }
        if (key.equals("txPower")) {
            return 9;
        }
        if (key.equals("major")) {
            return 10;
        }
        if (key.equals("minor")) {
            return 11;
        }
        if (key.equals("profiles")) {
            return 13;
        }
        if (key.equals("namespace")) {
            return 14;
        }
        if (key.equals("instanceId")) {
            return 15;
        }
        if (key.equals("url")) {
            return 16;
        }
        if (key.equals("name")) {
            return 17;
        }
        if (key.equals("password")) {
            return 18;
        }
        throw new IllegalStateException("Unrecognised tag: " + key);
    }

    static class Batch {
        private final Map<String, Object> PROCESS_ARGUMENTS = new HashMap<String, Object>();
        private final Map<String, Object> ROLLBACK_ARGUMENTS = new HashMap<String, Object>();

        Batch() {
        }

        private void notifyProcessChanged() {
            this.ROLLBACK_ARGUMENTS.entrySet().removeAll(this.PROCESS_ARGUMENTS.entrySet());
        }

        private Iterator<Map.Entry<String, Object>> processIterator() {
            return this.PROCESS_ARGUMENTS.entrySet().iterator();
        }

        private Iterator<Map.Entry<String, Object>> rollbackIterator() {
            return this.ROLLBACK_ARGUMENTS.entrySet().iterator();
        }

        private boolean isProcessEmpty() {
            return this.PROCESS_ARGUMENTS.isEmpty();
        }

        static Batch select(IConfig config, RemoteBluetoothDevice.Characteristics characteristics) {
            String devicePassword;
            int txPower;
            int minor;
            int major;
            List deviceProfile;
            SDKPreconditions.checkNotNull((Object)config, (Object)"Config is null");
            Batch batch = new Batch();
            String currentName = characteristics.getModelName();
            String desiredName = config.getDeviceName();
            if (!TextUtils.isEmpty((CharSequence)desiredName) && !currentName.equals(desiredName)) {
                batch.PROCESS_ARGUMENTS.put("name", desiredName);
                batch.ROLLBACK_ARGUMENTS.put("name", currentName);
            }
            if ((deviceProfile = config.getDeviceProfiles()) != null && !deviceProfile.isEmpty()) {
                DeviceProfile desiredProfile = (DeviceProfile)deviceProfile.get(0);
                DeviceProfile activeProfile = characteristics.getActiveProfile();
                if (activeProfile != null && desiredProfile != activeProfile) {
                    batch.PROCESS_ARGUMENTS.put("profiles", desiredProfile);
                    batch.ROLLBACK_ARGUMENTS.put("profiles", activeProfile);
                }
            }
            UUID proximityUUID = config.getProximityUUID();
            UUID characteristicProximityUUID = characteristics.getProximityUUID();
            if (proximityUUID != null && characteristicProximityUUID != null && !characteristics.getProximityUUID().equals(proximityUUID)) {
                batch.PROCESS_ARGUMENTS.put("proximity", proximityUUID);
                batch.ROLLBACK_ARGUMENTS.put("proximity", characteristicProximityUUID);
            }
            if ((major = config.getMajor()) >= 0 && major != characteristics.getMajor() && characteristics.getMajor() > -1) {
                batch.PROCESS_ARGUMENTS.put("major", major);
                batch.ROLLBACK_ARGUMENTS.put("major", characteristics.getMajor());
            }
            if ((minor = config.getMinor()) >= 0 && minor != characteristics.getMinor() && characteristics.getMinor() > -1) {
                batch.PROCESS_ARGUMENTS.put("minor", minor);
                batch.ROLLBACK_ARGUMENTS.put("minor", characteristics.getMinor());
            }
            long advertisingInterval = config.getInterval();
            long currentInterval = characteristics.getAdvertisingInterval();
            if (currentInterval != advertisingInterval && advertisingInterval > -1L) {
                batch.PROCESS_ARGUMENTS.put("interval", advertisingInterval);
                batch.ROLLBACK_ARGUMENTS.put("interval", currentInterval);
            }
            if ((txPower = config.getTxPower()) != characteristics.getPowerLevel()) {
                batch.PROCESS_ARGUMENTS.put("txPower", txPower);
                batch.ROLLBACK_ARGUMENTS.put("txPower", characteristics.getPowerLevel());
            }
            String namespace = config.getNamespace();
            String characteristicNamespace = characteristics.getNamespaceId();
            if (!TextUtils.isEmpty((CharSequence)namespace) && !TextUtils.equals((CharSequence)namespace, (CharSequence)characteristicNamespace)) {
                batch.PROCESS_ARGUMENTS.put("namespace", namespace);
                batch.ROLLBACK_ARGUMENTS.put("namespace", characteristicNamespace);
            }
            String instanceId = config.getInstanceId();
            String characteristicInstanceId = characteristics.getInstanceId();
            if (!TextUtils.isEmpty((CharSequence)instanceId) && !TextUtils.equals((CharSequence)instanceId, (CharSequence)characteristicInstanceId)) {
                batch.PROCESS_ARGUMENTS.put("instanceId", instanceId);
                batch.ROLLBACK_ARGUMENTS.put("instanceId", characteristicInstanceId);
            }
            String url = config.getUrl();
            String characteristicUrl = characteristics.getUrl();
            if (!TextUtils.isEmpty((CharSequence)url) && !TextUtils.equals((CharSequence)url, (CharSequence)characteristicUrl)) {
                batch.PROCESS_ARGUMENTS.put("url", url);
                batch.ROLLBACK_ARGUMENTS.put("url", characteristicUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)(devicePassword = config.getDevicePassword()))) {
                batch.PROCESS_ARGUMENTS.put("password", devicePassword);
            }
            return batch;
        }

        static Batch select(IPreset profile, RemoteBluetoothDevice.Characteristics characteristics) {
            int txPower;
            SDKPreconditions.checkNotNull((Object)profile, (Object)"Preset is null");
            Batch batch = new Batch();
            UUID proximityUUID = profile.getProximityUUID();
            if (proximityUUID != null && !characteristics.getProximityUUID().equals(proximityUUID)) {
                batch.PROCESS_ARGUMENTS.put("proximity", proximityUUID);
                batch.ROLLBACK_ARGUMENTS.put("proximity", proximityUUID);
            }
            long advertisingInterval = profile.getInterval();
            long currentInterval = characteristics.getAdvertisingInterval();
            if (currentInterval != advertisingInterval) {
                batch.PROCESS_ARGUMENTS.put("interval", advertisingInterval);
                batch.ROLLBACK_ARGUMENTS.put("interval", advertisingInterval);
            }
            if ((txPower = profile.getTxPower()) != characteristics.getPowerLevel()) {
                batch.PROCESS_ARGUMENTS.put("txPower", txPower);
                batch.ROLLBACK_ARGUMENTS.put("txPower", txPower);
            }
            return batch;
        }
    }

    static interface ProcessingListener {
        public void onStart();

        public void onError(int var1);

        public void onFinish();

        public void onRollbackStart();

        public void onRollbackFinish();

        public void onRollbackError(int var1);
    }
}

