/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.filter.eddystone.TLMFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.UIDFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.URLFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class ScanContextValidator {
    private static final int MAX_EDDYSTONE_FILTERS_SIZE = 5;
    private static final int MAX_IBEACON_FILTERS_SIZE = 10;
    private static final int REGIONS_LIMIT = 20;
    private static final long MINIMAL_ACTIVE_SCAN_PERIOD = TimeUnit.SECONDS.toMillis(3L);
    private static final long MINIMAL_POSITVE_PASSIVE_SCAN_PERIOD = TimeUnit.SECONDS.toMillis(2L);

    private ScanContextValidator() {
    }

    static void validate(ActivityCheckConfiguration activityCheckConfiguration) {
        long minimalInactivityTimeout;
        if (activityCheckConfiguration == ActivityCheckConfiguration.MINIMAL || activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        long inactivityTimeout = activityCheckConfiguration.getInactivityTimeout();
        SDKPreconditions.checkArgument((inactivityTimeout >= (minimalInactivityTimeout = ActivityCheckConfiguration.MINIMAL.getInactivityTimeout()) ? 1 : 0) != 0, (Object)"The inactivity timeout must be no shorter than 1 seconds");
        long checkPeriod = activityCheckConfiguration.getCheckPeriod();
        long minimalCheckPeriod = ActivityCheckConfiguration.MINIMAL.getCheckPeriod();
        SDKPreconditions.checkArgument((checkPeriod >= minimalCheckPeriod ? 1 : 0) != 0, (Object)"The check period must be no shorter than 1 second");
    }

    static void validate(ForceScanConfiguration forceScanConfiguration) {
        ForceScanConfiguration defaultConfig = ForceScanConfiguration.MINIMAL;
        long forceScanActivePeriod = defaultConfig.getForceScanActivePeriod();
        if (forceScanConfiguration.getForceScanActivePeriod() < forceScanActivePeriod) {
            throw new IllegalArgumentException(String.format("The Force Scan Active period must not be shorter than %d milliseconds", forceScanActivePeriod));
        }
        long forceScanPassivePeriod = defaultConfig.getForceScanPassivePeriod();
        if (forceScanConfiguration.getForceScanPassivePeriod() < forceScanPassivePeriod) {
            throw new IllegalArgumentException(String.format("The Force Scan Passive period must not be shorter than %d", forceScanPassivePeriod));
        }
    }

    static void validate(ScanPeriod scanPeriod) {
        long activeSubperiod = scanPeriod.getActivePeriod();
        SDKPreconditions.checkArgument((activeSubperiod >= MINIMAL_ACTIVE_SCAN_PERIOD ? 1 : 0) != 0, (Object)String.format("Active subperiod should last no shorter than %d seconds", MINIMAL_ACTIVE_SCAN_PERIOD / 1000L));
        long passiveSubPeriod = scanPeriod.getPassivePeriod();
        SDKPreconditions.checkArgument((passiveSubPeriod == 0L || passiveSubPeriod >= MINIMAL_POSITVE_PASSIVE_SCAN_PERIOD ? 1 : 0) != 0, (Object)"Unsupported ScanPeriod's passive period");
    }

    static void validateIBeaconRegionsCount(Collection<IBeaconRegion> iBeaconRegions) {
        SDKPreconditions.checkNotNull(iBeaconRegions, (Object)"Regions are null");
        SDKPreconditions.checkArgument((iBeaconRegions.size() <= 20 ? 1 : 0) != 0, (Object)"You can range beacons within max 20 regions.");
    }

    static void validateIBeaconFiltersCount(Collection<IBeaconFilter> filters) {
        SDKPreconditions.checkNotNull(filters, (Object)"IBeacon filters are null");
        SDKPreconditions.checkState((filters.size() <= 10 ? 1 : 0) != 0, (Object)"Too many iBeacon filters specified. The limit is 10");
    }

    static void validateEddystoneUIDFiltersCount(List<UIDFilter> eddystoneFilterList) {
        SDKPreconditions.checkNotNull(eddystoneFilterList, (Object)"Eddystone filters are null");
        SDKPreconditions.checkState((eddystoneFilterList.size() <= 5 ? 1 : 0) != 0, (Object)"Too many eddystone filters specified. The limit is 5");
    }

    static void validateEddystoneTLMFiltersCount(List<TLMFilter> eddystoneFilterList) {
        SDKPreconditions.checkNotNull(eddystoneFilterList, (Object)"Eddystone filters are null");
        SDKPreconditions.checkState((eddystoneFilterList.size() <= 5 ? 1 : 0) != 0, (Object)"Too many eddystone filters specified. The limit is 5");
    }

    static void validateEddystoneURLFiltersCount(List<URLFilter> eddystoneFilterList) {
        SDKPreconditions.checkNotNull(eddystoneFilterList, (Object)"Eddystone filters are null");
        SDKPreconditions.checkState((eddystoneFilterList.size() <= 5 ? 1 : 0) != 0, (Object)"Too many eddystone filters specified. The limit is 5");
    }

    static void validateNamespacesCount(Collection<IEddystoneNamespace> eddystoneNamespaceSet) {
        SDKPreconditions.checkNotNull(eddystoneNamespaceSet, (Object)"Eddystone namespaces are null");
        SDKPreconditions.checkArgument((eddystoneNamespaceSet.size() <= 20 ? 1 : 0) != 0, (Object)"You can range eddystones within max 20 namespaces.");
    }

    static void validateDevicesUpdateCallbackInterval(long devicesUpdateCallbackInterval) {
        SDKPreconditions.checkArgument((devicesUpdateCallbackInterval >= 0L ? 1 : 0) != 0, (Object)"Minimal callback period should be positive");
    }
}

