/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.configuration.scan.AbstractProfileSpecificScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.GlobalScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContextValidator;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class ScanContext
implements GlobalScanContext {
    public static final ScanContext DEFAULT = new Builder().setForceScanConfiguration(ForceScanConfiguration.DISABLED).setScanMode(0).setActivityCheckConfiguration(ActivityCheckConfiguration.MINIMAL).setEddystoneScanContext(EddystoneScanContext.DEFAULT).setIBeaconScanContext(IBeaconScanContext.DEFAULT).setScanPeriod(ScanPeriod.RANGING).build();
    private final int id;
    private final ForceScanConfiguration forceScanConfiguration;
    private final ScanPeriod scanPeriod;
    private final int scanMode;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final IBeaconScanContext iBeaconScanContext;
    private final EddystoneScanContext eddystoneScanContext;

    private ScanContext(Builder builder) {
        this.forceScanConfiguration = builder.forceScanConfiguration;
        this.scanPeriod = builder.scanPeriod;
        this.scanMode = builder.scanMode;
        this.activityCheckConfiguration = builder.activityCheckConfiguration;
        this.iBeaconScanContext = builder.iBeaconScanContext;
        this.eddystoneScanContext = builder.eddystoneScanContext;
        this.id = System.identityHashCode(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ActivityCheckConfiguration getActivityCheckConfiguration() {
        return this.activityCheckConfiguration;
    }

    @Override
    public IBeaconScanContext getIBeaconScanContext() {
        return this.iBeaconScanContext;
    }

    @Override
    public EddystoneScanContext getEddystoneScanContext() {
        return this.eddystoneScanContext;
    }

    @Override
    public ForceScanConfiguration getForceScanConfiguration() {
        return this.forceScanConfiguration;
    }

    @Override
    public ScanPeriod getScanPeriod() {
        return this.scanPeriod;
    }

    @Override
    public int getScanMode() {
        return this.scanMode;
    }

    public static final class Builder {
        private int scanMode = 1;
        private ForceScanConfiguration forceScanConfiguration = ForceScanConfiguration.DISABLED;
        private ScanPeriod scanPeriod = ScanPeriod.RANGING;
        private ActivityCheckConfiguration activityCheckConfiguration = ActivityCheckConfiguration.MINIMAL;
        private IBeaconScanContext iBeaconScanContext;
        private EddystoneScanContext eddystoneScanContext;

        public Builder setIBeaconScanContext(IBeaconScanContext iBeaconScanContext) {
            this.iBeaconScanContext = iBeaconScanContext;
            return this;
        }

        public Builder setEddystoneScanContext(EddystoneScanContext eddystoneScanContext) {
            this.eddystoneScanContext = eddystoneScanContext;
            return this;
        }

        public Builder setActivityCheckConfiguration(ActivityCheckConfiguration actvitivyCheckConfiguration) {
            SDKPreconditions.checkNotNull((Object)actvitivyCheckConfiguration, (Object)"Beacon activity check is null.");
            this.activityCheckConfiguration = actvitivyCheckConfiguration;
            return this;
        }

        public Builder setScanMode(int scanMode) {
            SDKPreconditions.checkArgument((scanMode == 1 || scanMode == 2 || scanMode == 0 ? 1 : 0) != 0, (Object)("Unknown scan mode specified: " + scanMode));
            this.scanMode = scanMode;
            return this;
        }

        public Builder setForceScanConfiguration(ForceScanConfiguration forceScanConfiguration) {
            SDKPreconditions.checkNotNull((Object)forceScanConfiguration, (Object)"By default ForceScanConfiguration is disabled");
            this.forceScanConfiguration = forceScanConfiguration;
            return this;
        }

        public Builder setScanPeriod(ScanPeriod scanPeriod) {
            SDKPreconditions.checkNotNull((Object)scanPeriod, (Object)"Monitor period cannot be null");
            ScanContextValidator.validate(scanPeriod);
            this.scanPeriod = scanPeriod;
            return this;
        }

        public ScanContext build() {
            if (this.activityCheckConfiguration != ActivityCheckConfiguration.DISABLED) {
                ScanContextValidator.validate(this.activityCheckConfiguration);
            }
            if (this.forceScanConfiguration != ForceScanConfiguration.DISABLED) {
                ScanContextValidator.validate(this.forceScanConfiguration);
            }
            String message = "At least one of: [IBeaconScanContext, EddystoneScanContext] must be set";
            SDKPreconditions.checkNotAllNull((RuntimeException)new IllegalStateException(message), (Object[])new AbstractProfileSpecificScanContext[]{this.iBeaconScanContext, this.eddystoneScanContext});
            return new ScanContext(this);
        }
    }
}

