/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.scan.ProfileSpecificScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContextValidator;
import com.kontakt.sdk.android.ble.discovery.DistanceSort;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculators;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;

abstract class AbstractProfileSpecificScanContext<S>
implements ProfileSpecificScanContext<S> {
    private static final Collection<EventType> ALL_EVENT_TYPES = EnumSet.allOf(EventType.class);
    private final int id;
    private final long devicesUpdateCallbackInterval;
    private final RssiCalculator rssiCalculator;
    private final DistanceSort distanceSort;
    private final Collection<EventType> eventTypes;

    protected AbstractProfileSpecificScanContext(Builder builder) {
        ScanContextValidator.validateDevicesUpdateCallbackInterval(builder.devicesUpdateCallbackInterval);
        this.devicesUpdateCallbackInterval = builder.devicesUpdateCallbackInterval;
        this.rssiCalculator = builder.rssiCalculator;
        this.distanceSort = builder.distanceSort;
        this.eventTypes = Collections.unmodifiableCollection(new HashSet(builder.eventTypes.isEmpty() ? ALL_EVENT_TYPES : builder.eventTypes));
        this.id = System.identityHashCode(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long getDevicesUpdateCallbackInterval() {
        return this.devicesUpdateCallbackInterval;
    }

    @Override
    public RssiCalculator getRssiCalculator() {
        return this.rssiCalculator;
    }

    @Override
    public DistanceSort getDistanceSort() {
        return this.distanceSort;
    }

    @Override
    public Collection<EventType> getEventTypes() {
        return this.eventTypes;
    }

    static abstract class Builder<B, T extends Builder> {
        private long devicesUpdateCallbackInterval = 100L;
        private RssiCalculator rssiCalculator = RssiCalculators.DEFAULT;
        private DistanceSort distanceSort = DistanceSort.DISABLED;
        private Collection<EventType> eventTypes = new HashSet<EventType>(EventType.values().length);

        Builder() {
        }

        protected abstract T getExtension();

        public abstract B build();

        public T setDevicesUpdateCallbackInterval(long devicesUpdateCallbackInterval) {
            SDKPreconditions.checkArgument((devicesUpdateCallbackInterval >= 0L ? 1 : 0) != 0, (Object)"Minimal callback period should be positive");
            this.devicesUpdateCallbackInterval = devicesUpdateCallbackInterval;
            return this.getExtension();
        }

        public T setRssiCalculator(RssiCalculator rssiCalculator) {
            SDKPreconditions.checkNotNull((Object)rssiCalculator, (Object)"Rssi calculator is null");
            this.rssiCalculator = rssiCalculator;
            return this.getExtension();
        }

        public T setDistanceSort(DistanceSort distanceSort) {
            SDKPreconditions.checkNotNull((Object)((Object)distanceSort), (Object)"Distance sort is null");
            this.distanceSort = distanceSort;
            return this.getExtension();
        }

        public T setEventTypes(Collection<EventType> eventTypes) {
            SDKPreconditions.checkNotNull(eventTypes, (Object)"Event types are null");
            this.eventTypes.addAll(eventTypes);
            return this.getExtension();
        }
    }
}

