/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.kontakt.sdk.android.ble.broadcast.OnBluetoothStateChangeListener;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class BluetoothStateChangeReceiver
extends BroadcastReceiver {
    public static final String ACTION = "android.bluetooth.adapter.action.STATE_CHANGED";
    private final OnBluetoothStateChangeListener stateChangeListener;

    public BluetoothStateChangeReceiver(OnBluetoothStateChangeListener stateChangeListener) {
        SDKPreconditions.checkNotNull((Object)stateChangeListener, (Object)"State change listener cannot be null");
        this.stateChangeListener = stateChangeListener;
    }

    public void onReceive(Context context, Intent intent) {
        if (!ACTION.equals(intent.getAction())) {
            return;
        }
        int bluetoothState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
        switch (bluetoothState) {
            case 10: {
                this.stateChangeListener.onBluetoothDisconnected();
                break;
            }
            case 12: {
                this.stateChangeListener.onBluetoothConnected();
                break;
            }
            case 11: {
                this.stateChangeListener.onBluetoothConnecting();
                break;
            }
            case 13: {
                this.stateChangeListener.onBluetoothDisconnecting();
                break;
            }
        }
    }
}

