package com.kontakt.sdk.android.ble.discovery.ibeacon;


import com.kontakt.sdk.android.common.Proximity;

import java.util.UUID;

/**
 *
 * AdvertisingPackage provides parsed data from received in Scan Record.
 */
public interface IBeaconAdvertisingPacket {
    /**
     * Provides advertising data.
     *
     * @return the advertising data
     */
    byte[] getManufacturerData();

    /**
     * Provides service data.
     *
     * @return the byte [ ]
     */
    byte[] getServiceData();

    /**
     * Provides rssi.
     *
     * @return the rssi
     */
    double getRssi();

    /**
     * Provides proximity uUID.
     *
     * @return the proximity uUID
     */
    UUID getProximityUUID();

    /**
     * Provides major.
     *
     * @return the major
     */
    int getMajor();

    /**
     * Provides minor.
     *
     * @return the minor
     */
    int getMinor();

    /**
     * Provides beacon unique id.
     *
     * @return the beacon unique id
     */
    String getBeaconUniqueId();

    /**
     * Provides firmware version.
     *
     * @return the firmware version
     */
    String getFirmwareVersion();

    /**
     * Provides battery percentage power.
     *
     * @return the battery percentage power
     */
    int getBatteryPercentagePower();

    /**
     * Provides tx power.
     *
     * @return the tx power
     */
    int getTxPower();

    /**
     * Provides accuracy.
     *
     * @return the accuracy
     */
    double getDistance();


    /**
     * Provides proximity.
     *
     * @return the proximity
     */
    Proximity getProximity();

    /**
     * Provides timestamp indicating when Beacon was found.
     *
     * @return the timestamp
     */
    long getTimestamp();

    /**
     * Provides name.
     *
     * @return the name
     */
    String getName();

    /**
     * Provides address.
     *
     * @return the address
     */
    String getAddress();

    /**
     * Provides device hash code.
     *
     * @return the device hash code
     */
    int getDeviceHashCode();

    boolean isShuffled();
}
