package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.common.util.ConversionUtils;

final class NamespaceIdResolver implements EddystonePropertyResolver<String> {

    static final int NAMESPACE_ID_START_INDEX = 13;

    private static final int NAMESPACE_ID_LENGTH = 10;

    private static final int MASK = 0x00FF;

    private static final String FORMAT = "%02x";

    private final StringBuilder namespaceIdBuilder = new StringBuilder();

    @Override
    public byte[] extract(byte[] scanRecord) {
        return ConversionUtils.extractPayload(
                scanRecord,
                NAMESPACE_ID_START_INDEX,
                NAMESPACE_ID_LENGTH
        );
    }

    @Override
    public String parse(byte[] source) {

        if(source == null) {
            return null;
        }

        namespaceIdBuilder.setLength(0);

        for(byte byteValue : source) {
            namespaceIdBuilder.append(String.format(FORMAT, byteValue & MASK));
        }

        return namespaceIdBuilder.toString();
    }
}
