package com.kontakt.sdk.android.ble.discovery.eddystone;

/**
 * Interface representing Eddystone URL advertising packet.
 * The URL advertising packat has the following structure:
 * [0] - url prefix
 * [1]...[n] - url length
 */
public interface EddystoneURLAdvertisingPacket {
    /**
     * Provides url bytes.
     *
     * @return url byte array
     */
    byte[] getUrlBytes();

    /**
     * Provides url.
     *
     * @return the url
     */
    String getUrl();
}
