package com.kontakt.sdk.android.ble.discovery.eddystone;

/**
 * An interface representing Eddystone UID advertising packet.
 *
 * The packet has the following structure:
 *
 * <ul>
 *     <li>[0]..[9] - namespace id bytes</li>
 *     <li>[10]..[15] - instance id bytes</li>
 * </ul>
 *
 */
public interface EddystoneUIDAdvertisingPacket {
    /**
     * Get namespace id bytes.
     * @return the namespace id bytes
     */
    byte[] getNamespaceIdBytes();

    /**
     * Provides namespace id.
     *
     * @return the namespace id
     */
    String getNamespaceId();

    /**
     * Provides instance id bytes.
     *
     * @return the byte [ ]
     */
    byte[] getInstanceIdBytes();

    /**
     * Provides instance id.
     *
     * @return the instance id
     */
    String getInstanceId();

    /**
     * Provides unique id.
     *
     * @return the unique id
     */
    String getEddystoneUniqueId();


    /**
     * Provides firmware version.
     *
     * @return the firmware version
     */
    String getFirmwareVersion();


    boolean isShuffled();
}
