package com.kontakt.sdk.android.ble.discovery;

/**
 * Distance Sort specifies in which order should the discovered devices be sorted according to
 * their distance from the Android device.
 * It indicates whether and how Beacons should be sorted by calculated accuracy.
 */
public enum DistanceSort {
    /**
     * The ASC value indicates that Beacons will be sorted in the ascending order.
     */
    ASC,
    /**
     * The DESC value indicates that Beacons will be sorted in the descending order.
     */
    DESC,
    /**
     * The DISABLED value indicates that sorting is disabled. When
     * DistanceSort is not specified, this value is applied to the
     * configuration.
     */
    DISABLED
}
