package com.kontakt.sdk.android.ble.discovery;

/**
 * Interface representing Discovery contract.
 */
public interface DiscoveryContract {

    /**
     * Notifies that the scan has started.
     */
    void onScanStarted();

    /**
     * Notifies about specific event occurence.
     *
     * @param event the event
     */
    void onEvent(BluetoothDeviceEvent event);

    /**
     * Notifires that the scan has stopped.
     */
    void onScanStopped();
}
