package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.manager.ServiceConnector;

/**
 * The listener indicating that Object implementing ServiceConnector interface
 * ({@link ServiceConnector}) successfully connected to the corresponding service.
 */
public interface OnServiceReadyListener {
    /**
     * Called when Object implementing ServiceConnector interface successfully
     * connected to the corresponding service.
     */
    void onServiceReady();

    /**
     * Called when an error occurs during establishing connection to the corresponding service.
     */
    void onConnectionFailure();
}
