/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http.data;

import com.kontakt.sdk.android.common.model.IManager;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.data.AbstractEntityData;
import com.kontakt.sdk.android.http.data.EntityData;
import java.util.UUID;

public class ManagerData
extends AbstractEntityData {
    private static final String MANAGER_ID_PARAMETER = "managerId";
    private static final String EMAIL_PARAMETER = "email";
    private static final String FIRST_NAME_PARAMETER = "firstName";
    private static final String LAST_NAME_PARAMETER = "lastName";
    private static final String ROLE_PARAMETER = "role";

    private ManagerData(EntityData entityData) {
        super(entityData);
    }

    public static Builder create(String firstName, String lastName, String email, IManager.Role role) {
        SDKPreconditions.checkNotNullOrEmpty((String)firstName, (String)"First Name is null or empty");
        SDKPreconditions.checkNotNullOrEmpty((String)lastName, (String)"Last Name is null or empty");
        SDKPreconditions.checkNotNullOrEmpty((String)email, (String)"Email is null or empty");
        SDKPreconditions.checkNotNull((Object)role, (Object)"Role is null");
        return new Builder(firstName, lastName, email, role);
    }

    public static Builder update(UUID managerId) {
        SDKPreconditions.checkNotNull((Object)managerId, (Object)"Manager id is null");
        return new Builder(managerId);
    }

    public static final class Builder {
        private final EntityData.Builder builder = new EntityData.Builder();

        private Builder(UUID managerId) {
            this.builder.addParameter(ManagerData.MANAGER_ID_PARAMETER, managerId.toString());
        }

        private Builder(String firstName, String lastName, String email, IManager.Role role) {
            this.withFirstName(firstName).withLastName(lastName).withRole(role);
            this.builder.addParameter(ManagerData.EMAIL_PARAMETER, email);
        }

        public Builder withFirstName(String firstName) {
            this.builder.addParameter(ManagerData.FIRST_NAME_PARAMETER, firstName);
            return this;
        }

        public Builder withLastName(String lastName) {
            this.builder.addParameter(ManagerData.LAST_NAME_PARAMETER, lastName);
            return this;
        }

        public Builder withRole(IManager.Role role) {
            SDKPreconditions.checkNotNull((Object)role, (Object)"Role is null");
            this.builder.addParameter(ManagerData.ROLE_PARAMETER, role.name());
            return this;
        }

        public ManagerData build() {
            return new ManagerData(this.builder.build());
        }
    }
}

