/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http.data;

import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.data.EntityData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractEntityData {
    private final EntityData entityData;

    protected AbstractEntityData(EntityData entityData) {
        this.entityData = entityData;
    }

    public final List<Map.Entry<String, String>> getParameters() {
        return this.entityData.getParameters();
    }

    public final boolean containsParameterKey(String key) {
        SDKPreconditions.checkNotNull((Object)key);
        for (Map.Entry<String, String> parameter : this.entityData.getParameters()) {
            if (!parameter.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsParameter(String key, String value) {
        SDKPreconditions.checkNotNull((Object)key);
        SDKPreconditions.checkNotNull((Object)value);
        for (Map.Entry<String, String> entry : this.entityData.getParameters()) {
            if (!entry.getKey().equals(key) || !entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public final List<String> getParameterValues(String name) {
        SDKPreconditions.checkNotNull((Object)name);
        ArrayList<String> parameterValueList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.entityData.getParameters()) {
            if (!entry.getKey().equals(name)) continue;
            parameterValueList.add(entry.getValue());
        }
        return Collections.unmodifiableList(parameterValueList);
    }
}

