/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.OrderBy;
import java.net.URI;
import org.json.JSONObject;

public final class SearchMeta {
    public static final String JSON_ENTRY = "searchMeta";
    private final int startIndex;
    private final int offset;
    private final SDKOptional<URI> previousResultsURI;
    private final SDKOptional<URI> nextResultsURI;
    private final Order order;
    private final OrderBy orderBy;

    private SearchMeta(Builder builder) {
        this.startIndex = builder.startIndex;
        this.offset = builder.offset;
        this.order = builder.order;
        this.orderBy = builder.orderBy;
        String previousResults = builder.previousResults;
        this.previousResultsURI = previousResults == null || previousResults.isEmpty() ? SDKOptional.absent() : SDKOptional.of((Object)URI.create(builder.previousResults));
        String nextResults = builder.nextResults;
        this.nextResultsURI = nextResults == null || nextResults.isEmpty() ? SDKOptional.absent() : SDKOptional.of((Object)URI.create(builder.nextResults));
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasPreviousResultsURI() {
        return this.previousResultsURI.isPresent();
    }

    public URI getPreviousResultsURI() {
        return (URI)this.previousResultsURI.get();
    }

    public URI getNextResultsURI() {
        return (URI)this.nextResultsURI.get();
    }

    public Order getOrder() {
        return this.order;
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.startIndex).append(this.offset).append(this.previousResultsURI).append(this.nextResultsURI).append((Object)this.order.name()).append((Object)this.orderBy.name()).build();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return false;
        }
        if (obj == null || !(obj instanceof SearchMeta)) {
            return false;
        }
        SearchMeta searchMeta = (SearchMeta)obj;
        return this.offset == searchMeta.offset && this.startIndex == searchMeta.startIndex && this.nextResultsURI.equals(searchMeta.nextResultsURI) && this.previousResultsURI.equals(searchMeta.previousResultsURI);
    }

    public String toString() {
        return "SearchMeta[" + "offset: " + this.offset + " " + "startIndex: " + this.startIndex + " " + "nextResultsURI: " + this.nextResultsURI + " " + "previousResultsURI: " + this.previousResultsURI + "]";
    }

    public static SearchMeta from(JSONObject jsonObject) {
        return new Builder().setStartIndex(JSONUtils.getInt((JSONObject)jsonObject, (String)"startIndex", (int)0)).setOffset(JSONUtils.getInt((JSONObject)jsonObject, (String)"maxResult", (int)0)).setNextResults(JSONUtils.getString((JSONObject)jsonObject, (String)"nextResults", (String)"")).setPreviousResults(JSONUtils.getString((JSONObject)jsonObject, (String)"prevResults", (String)"")).setOrder(Order.valueOf((String)JSONUtils.getString((JSONObject)jsonObject, (String)"order", (String)Order.ASC.name()))).setOrderBy(OrderBy.fromJSON(JSONUtils.getString((JSONObject)jsonObject, (String)"orderBy", (String)OrderBy.CREATION.name()))).build();
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public boolean hasNextResultsURI() {
        return this.nextResultsURI.isPresent();
    }

    public static class Builder {
        private int startIndex = 0;
        private int offset = 0;
        private String previousResults = "";
        private String nextResults = "";
        private OrderBy orderBy = OrderBy.CREATION;
        private Order order = Order.ASC;

        public Builder setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder setOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder setPreviousResults(String previousResults) {
            this.previousResults = previousResults;
            return this;
        }

        public Builder setNextResults(String nextResults) {
            this.nextResults = nextResults;
            return this;
        }

        public Builder setOrderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder setOrder(Order order) {
            this.order = order;
            return this;
        }

        public SearchMeta build() {
            return new SearchMeta(this);
        }
    }
}

