/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.data.ActionData;
import java.io.File;
import java.util.UUID;

final class RequestValidator {
    private RequestValidator() {
    }

    public static void validateETag(SDKOptional<ETag> eTag) {
        SDKPreconditions.checkNotNull(eTag, (Object)"ETag optional cannot be null.");
        if (eTag.isPresent()) {
            SDKPreconditions.checkNotNullOrEmpty((String)((ETag)eTag.get()).getValue(), (String)"ETag value is null.");
        }
    }

    static void contentActionCreationPreconditions(ActionData actionData, File file) {
        SDKPreconditions.checkState((boolean)actionData.containsParameter("actionType", IAction.ActionType.CONTENT.name()), (Object)"Action Type must be of CONTENT type");
        SDKPreconditions.checkState((boolean)actionData.containsParameterKey("uniqueId"), (Object)"No Parameter with Device Unique Id");
        SDKPreconditions.checkNotNull((Object)file, (Object)"File data is null.");
        SDKPreconditions.checkState((boolean)file.exists(), (Object)"File does not exist");
        SDKPreconditions.checkState((boolean)actionData.containsParameterKey("proximity"), (Object)"Proximity not included as parameter. Should be one of three values: IMMEDIATE, NEAR, FAR");
    }

    static void browserActionCreationPreconditions(ActionData actionData) {
        SDKPreconditions.checkState((boolean)actionData.containsParameter("actionType", IAction.ActionType.BROWSER.name()), (Object)"Action Type must be of BROWSER type");
        SDKPreconditions.checkState((boolean)actionData.containsParameterKey("uniqueId"), (Object)"No Parameter with Device Unique Id");
        SDKPreconditions.checkState((boolean)actionData.containsParameterKey("proximity"), (Object)"Proximity not included as parameter. Should be one of three values: IMMEDIATE, NEAR, FAR");
        SDKPreconditions.checkState((boolean)actionData.containsParameterKey("url"), (Object)"Url parameter must be included");
    }

    static void actionRetrievalPreconditions(UUID actionId, SDKOptional<ETag> etag) {
        SDKPreconditions.checkNotNull((Object)actionId, (Object)"Action Id is null");
        RequestValidator.validateETag(etag);
    }

    static void actionUpdatePreconditions(UUID actionId, File file) {
        SDKPreconditions.checkNotNull((Object)actionId, (Object)"Content action ID is null.");
        SDKPreconditions.checkNotNull((Object)file, (Object)"Content file to update is null.");
        SDKPreconditions.checkArgument((file.exists() && file.isFile() ? 1 : 0) != 0, (Object)"File either does not exist or is directory");
    }

    static void actionUpdatePreconditions(UUID actionId, String url) {
        SDKPreconditions.checkNotNull((Object)actionId, (Object)"Content action ID is null.");
        SDKPreconditions.checkNotNullOrEmpty((String)url, (String)"Url is null or empty");
    }

    static void actionDeletionPreconditions(UUID actionId) {
        SDKPreconditions.checkNotNull((Object)actionId, (Object)"Action id is null");
    }

    static void configsListingPreconditions(RequestDescription requestDescription) {
        SDKPreconditions.checkState((boolean)requestDescription.containsParameter("deviceType", DeviceType.BEACON.name()), (Object)"DeviceType.BEACON is required.");
    }

    static void cloudConfigsListingPreconditions(RequestDescription requestDescription) {
        SDKPreconditions.checkState((boolean)requestDescription.containsParameter("deviceType", DeviceType.CLOUD_BEACON.name()), (Object)"DeviceType.CLOUD_BEACON is required");
    }
}

