/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.OrderBy;
import com.squareup.okhttp.Headers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RequestDescription {
    private final int startIndex;
    private final int offset;
    private final ETag eTag;
    private final Order order;
    private final OrderBy orderBy;
    private final Headers headers;
    private final List<Map.Entry<String, String>> parameters;

    private RequestDescription(Descriptor descriptor) {
        this.startIndex = descriptor.startIndex;
        this.offset = descriptor.offset;
        this.eTag = descriptor.eTag;
        this.order = descriptor.order;
        this.orderBy = descriptor.orderBy;
        this.headers = descriptor.additionalHeaders.build();
        this.parameters = descriptor.additionalParameters;
    }

    public static Descriptor start() {
        return new Descriptor();
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public List<Map.Entry<String, String>> getParameters() {
        return this.parameters;
    }

    public boolean containsParameter(String name, String value) {
        SDKPreconditions.checkNotNull((Object)name, (Object)"Parameter name is null");
        SDKPreconditions.checkNotNull((Object)value, (Object)"Parameter value is null");
        for (Map.Entry<String, String> entry : this.parameters) {
            if (!entry.getKey().equals(name) || !entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public ETag getETag() {
        return this.eTag;
    }

    public Order getOrder() {
        return this.order;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public int getResultsStartIndex() {
        return this.startIndex;
    }

    public int getResultsOffset() {
        return this.offset;
    }

    public static final class Descriptor {
        private static final int FORBIDDEN_VALUE = -1;
        private int startIndex = -1;
        private int offset = -1;
        private ETag eTag;
        private Order order;
        private OrderBy orderBy;
        private Headers.Builder additionalHeaders = new Headers.Builder();
        private List<Map.Entry<String, String>> additionalParameters = new ArrayList<Map.Entry<String, String>>();

        private Descriptor() {
        }

        public Descriptor setETag(ETag eTag) {
            this.eTag = eTag;
            return this;
        }

        public Descriptor setOrder(Order order) {
            this.order = order;
            return this;
        }

        public Descriptor addHeader(String name, String value) {
            this.additionalHeaders.add(name, value);
            return this;
        }

        public Descriptor addParameter(String name, String value) {
            this.additionalParameters.add(HttpUtils.toUrlParameter((String)name, (String)value));
            return this;
        }

        public Descriptor addParameters(List<Map.Entry<String, String>> parameterList) {
            this.additionalParameters.addAll(parameterList);
            return this;
        }

        public Descriptor setOrderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Descriptor setOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public Descriptor setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public RequestDescription build() {
            if (this.eTag != null) {
                this.additionalHeaders.add(this.eTag.getRequestName(), this.eTag.getValue());
            }
            if (this.order != null) {
                this.additionalParameters.add(HttpUtils.toUrlParameter((String)"order", (String)this.order.name()));
            }
            if (this.orderBy != null) {
                this.additionalParameters.add(HttpUtils.toUrlParameter((String)"orderBy", (String)this.orderBy.getArgument()));
            }
            if (this.startIndex >= 0) {
                this.additionalParameters.add(HttpUtils.toUrlParameter((String)"startIndex", (String)String.valueOf(this.startIndex)));
            }
            if (this.offset >= 0) {
                this.additionalParameters.add(HttpUtils.toUrlParameter((String)"maxResult", (String)String.valueOf(this.offset)));
            }
            return new RequestDescription(this);
        }
    }
}

