/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.IManager;
import com.kontakt.sdk.android.common.model.Manager;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.data.ManagerData;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.ManagersApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.kontakt.sdk.android.http.interfaces.UpdateApiCallback;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.JSONObject;

final class ManagersApiAccessorImpl
extends AbstractApiAccessor
implements ManagersApiAccessor {
    ManagersApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<IManager> createManager(ManagerData manager) throws ClientException {
        return this.createAndTransform("manager/create", manager, new SDKFunction<JSONObject, IManager>(){

            public IManager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public void createManager(ManagerData managerData, ResultApiCallback<IManager> apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameters(managerData.getParameters()).build();
        this.postAsyncAndBuildFromJSONObject("manager/create", requestDescription, 201, apiCallback, new SDKFunction<JSONObject, IManager>(){

            public IManager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IManager> getManager(UUID managerId, SDKOptional<ETag> eTagOptional) throws ClientException {
        String uri = String.format("manager/%s", managerId.toString());
        RequestDescription requestDescription = RequestDescription.start().setETag(eTagOptional.isPresent() ? (ETag)eTagOptional.get() : null).build();
        return this.getAndTransform(uri, requestDescription, new SDKFunction<JSONObject, IManager>(){

            public IManager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public void getManager(UUID managerId, SDKOptional<ETag> etag, ResultApiCallback<IManager> apiCallback) {
        String uri = String.format("manager/%s", managerId.toString());
        RequestDescription requestDescription = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        this.getAsync(uri, requestDescription, 200, apiCallback, JSON_OBJECT_EXTRACT_FUNCTION, new SDKFunction<JSONObject, IManager>(){

            public IManager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IManager> getManager(UUID managerId) throws ClientException {
        return this.getManager(managerId, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getManager(UUID managerId, ResultApiCallback<IManager> apiCallback) {
        this.getManager(managerId, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<List<IManager>> listSubordinatesForManager(UUID managerId, RequestDescription requestDescription) throws ClientException {
        String uri = String.format("manager/%s/subordinate", managerId.toString());
        return this.getAndTransformToList(uri, requestDescription, "managers", new SDKFunction<JSONObject, IManager>(){

            public IManager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IManager>> listSubordinatesForManager(UUID managerId) throws ClientException {
        return this.listSubordinatesForManager(managerId, DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listSubordinatesForManager(UUID managerId, RequestDescription requestDescription, ResultApiCallback<List<IManager>> resultApiCallback) {
        String uri = String.format("manager/%s/subordinate", managerId.toString());
        this.transformToListAsynchronously(uri, requestDescription, 200, "managers", resultApiCallback, new SDKFunction<JSONObject, IManager>(){

            public IManager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listSubordinatesForManager(UUID managerId, ResultApiCallback<List<IManager>> resultApiCallback) {
        this.listSubordinatesForManager(managerId, DEFAULT_REQUEST_DESCRIPTION, resultApiCallback);
    }

    @Override
    public int updateManager(ManagerData managerData) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameters(managerData.getParameters()).build();
        return this.postAndReturnHttpStatus("manager/update", requestDescription);
    }

    @Override
    public void updateManager(ManagerData managerData, UpdateApiCallback updateApiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameters(managerData.getParameters()).build();
        this.postAsyncAndReturnHttpStatus("manager/update", requestDescription, updateApiCallback);
    }

    @Override
    public int assignManagersToSupervisor(UUID supervisorId, Set<UUID> managerIdSet) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("supervisorId", supervisorId.toString()).addParameters(HttpUtils.toUrlParameterList((String)"managerId", managerIdSet)).build();
        return this.postAndReturnHttpStatus("manager/assign", requestDescription);
    }

    @Override
    public void assignManagersToSupervisor(UUID supervisorId, Set<UUID> managerIdSet, UpdateApiCallback apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("supervisorId", supervisorId.toString()).addParameters(HttpUtils.toUrlParameterList((String)"managerId", managerIdSet)).build();
        this.postAsyncAndReturnHttpStatus("manager/assign", requestDescription, apiCallback);
    }

    @Override
    public HttpResult<List<IManager>> listManagers(RequestDescription requestDescription) throws ClientException {
        return this.getAndTransformToList("manager", requestDescription, "managers", new SDKFunction<JSONObject, IManager>(){

            public Manager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<List<IManager>> listManagers() throws ClientException {
        return this.listManagers(DEFAULT_REQUEST_DESCRIPTION);
    }

    @Override
    public void listManagers(RequestDescription requestDescription, ResultApiCallback<List<IManager>> apiCallback) {
        this.transformToListAsynchronously("manager", requestDescription, 200, "managers", apiCallback, new SDKFunction<JSONObject, IManager>(){

            public IManager apply(JSONObject object) {
                return Manager.from((JSONObject)object);
            }
        });
    }

    @Override
    public void listManagers(ResultApiCallback<List<IManager>> apiCallback) {
        this.listManagers(DEFAULT_REQUEST_DESCRIPTION, apiCallback);
    }

    @Override
    public int deleteManager(UUID managerId) throws ClientException {
        RequestDescription requestDescription = RequestDescription.start().addParameter("managerId", managerId.toString()).build();
        return this.postAndReturnHttpStatus("manager/delete", requestDescription);
    }

    @Override
    public void deleteManager(UUID managerId, UpdateApiCallback apiCallback) {
        RequestDescription requestDescription = RequestDescription.start().addParameter("managerId", managerId.toString()).build();
        this.postAsyncAndReturnHttpStatus("manager/delete", requestDescription, apiCallback);
    }
}

