/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import android.util.SparseArray;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.SearchMeta;

public final class HttpResult<T> {
    private static final SparseArray<String> API_STATUS_INFO_CACHE = new SparseArray();
    private final T result;
    private final int httpStatus;
    private final String message;
    private final ETag eTag;
    private final SearchMeta searchMeta;
    private final String reasonPhrase;

    private HttpResult(Builder<T> builder) {
        this.result = ((Builder)builder).value;
        this.httpStatus = ((Builder)builder).httpStatus;
        String m = (String)API_STATUS_INFO_CACHE.get(this.httpStatus);
        this.message = m == null ? "" : m;
        this.eTag = ETag.of(((Builder)builder).etagValue);
        this.searchMeta = ((Builder)builder).searchMeta;
        this.reasonPhrase = ((Builder)builder).reasonPhrase;
    }

    public T get() {
        SDKPreconditions.checkState((boolean)this.isPresent(), (Object)String.format("Invalid http status: %d (%s). Result is null.", this.httpStatus, API_STATUS_INFO_CACHE.get(this.httpStatus)));
        return this.result;
    }

    public int getStatusCode() {
        return this.httpStatus;
    }

    public boolean isPresent() {
        return this.result != null;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isETagPresent() {
        return this.eTag != null;
    }

    public ETag getETag() {
        SDKPreconditions.checkNotNull((Object)this.eTag, (Object)"ETag is not present");
        return this.eTag;
    }

    public boolean isSearchMetaPresent() {
        return this.searchMeta != null;
    }

    public SearchMeta getSearchMeta() {
        SDKPreconditions.checkNotNull((Object)this.searchMeta, (Object)"SearchMeta is not present");
        return this.searchMeta;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public static <T> HttpResult<T> of(int httpStatus) {
        return new Builder().setHttpStatus(httpStatus).build();
    }

    static {
        API_STATUS_INFO_CACHE.put(200, (Object)"Request has been valid and successful");
        API_STATUS_INFO_CACHE.put(201, (Object)"Entity has been created successfully");
        API_STATUS_INFO_CACHE.put(204, (Object)"Request has been valid and there is no content");
        API_STATUS_INFO_CACHE.put(303, (Object)"Request has been valid, but needed to be redirected elsewhere");
        API_STATUS_INFO_CACHE.put(400, (Object)"Request contains invalid values or is in invalid format");
        API_STATUS_INFO_CACHE.put(401, (Object)"Unauthorized access. Most likely Api-Key hasn\u2019t been sent or empty");
        API_STATUS_INFO_CACHE.put(403, (Object)"The request was a valid request, but the server is refusing to respond to it");
        API_STATUS_INFO_CACHE.put(404, (Object)"Resource not found");
        API_STATUS_INFO_CACHE.put(405, (Object)"A request was made of a resource using a request method not supported by that resource; for example, using GET on a form which requires data to be presented via POST, or using PUT on a read-only resource.");
        API_STATUS_INFO_CACHE.put(409, (Object)"Request could not be processed because of conflict");
        API_STATUS_INFO_CACHE.put(415, (Object)"Version or Mediatype not found");
        API_STATUS_INFO_CACHE.put(422, (Object)"Parameters validation error");
        API_STATUS_INFO_CACHE.put(500, (Object)"Internal Server Error occured");
        API_STATUS_INFO_CACHE.put(502, (Object)"The server was acting as a gateway or proxy and received an invalid response from the upstream server.");
        API_STATUS_INFO_CACHE.put(504, (Object)"The server is currently unavailable (because it is overloaded or down for maintenance). Generally, this is a temporary state");
        API_STATUS_INFO_CACHE.put(304, (Object)"The resource has not been modified since the version specified by the request newHeader If-None-Match.");
    }

    public static final class Builder<T> {
        private T value;
        private int httpStatus;
        private String etagValue;
        private SearchMeta searchMeta;
        private String reasonPhrase;

        public Builder<T> setValue(T value) {
            this.value = value;
            return this;
        }

        public Builder<T> setHttpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public Builder<T> setETagValue(String etagValue) {
            this.etagValue = etagValue;
            return this;
        }

        public Builder<T> setSearchMeta(SearchMeta searchMeta) {
            this.searchMeta = searchMeta;
            return this;
        }

        public Builder<T> setReasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
            return this;
        }

        public HttpResult<T> build() {
            return new HttpResult(this);
        }
    }
}

