/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import android.text.TextUtils;
import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.interfaces.SDKThrowableFunction;
import com.kontakt.sdk.android.common.util.JSONUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.SearchMeta;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class FluentResponse<T> {
    private final Response httpResponse;
    private final int actualHttpStatus;
    private final List<Integer> expectedHttpStatuses;

    public static <T> FluentResponse<T> of(Response httpResponse, int expectedHttpStatus) {
        SDKPreconditions.checkNotNull((Object)httpResponse, (Object)"Http Response is null.");
        return new FluentResponse<T>(httpResponse, new int[]{expectedHttpStatus});
    }

    public static <T> FluentResponse<T> of(Response httpResponse, int[] expectedHttpStatuses) {
        SDKPreconditions.checkNotNull((Object)httpResponse, (Object)"Http Response is null.");
        return new FluentResponse<T>(httpResponse, expectedHttpStatuses);
    }

    private FluentResponse(Response httpResponse, int[] expectedHttpStatus) {
        this.httpResponse = httpResponse;
        this.actualHttpStatus = httpResponse.code();
        this.expectedHttpStatuses = new ArrayList<Integer>();
        for (int expectedStatus : expectedHttpStatus) {
            this.expectedHttpStatuses.add(expectedStatus);
        }
    }

    private boolean isInExpectedHttpStatuses() {
        return this.expectedHttpStatuses.contains(this.actualHttpStatus);
    }

    public JSONResponse<T> transformToJSON() {
        try {
            String response;
            if (this.isInExpectedHttpStatuses() && !TextUtils.isEmpty((CharSequence)(response = this.httpResponse.body().string()))) {
                return new JSONResponse(SDKOptional.of((Object)new JSONObject(response)));
            }
            return new JSONResponse(SDKOptional.absent());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public ByteArrayResponse<T> transformToByteArray() {
        try {
            return new ByteArrayResponse(this.httpResponse.body().bytes());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static SearchMeta parseSearchMeta(JSONObject jsonObject) {
        try {
            return JSONUtils.hasJSONKey((JSONObject)jsonObject, (String)"searchMeta") ? (SearchMeta)JSONUtils.transformOrThrow((JSONObject)jsonObject.getJSONObject("searchMeta"), (SDKThrowableFunction)new SDKThrowableFunction<JSONObject, SearchMeta, Exception>(){

                public SearchMeta apply(JSONObject object) throws Exception {
                    return SearchMeta.from(object);
                }
            }) : null;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public final class ByteArrayResponse<T> {
        final byte[] content;

        private ByteArrayResponse(byte[] content) {
            this.content = content;
        }

        public HttpResult<T> toHttpResult(SDKFunction<byte[], T> buildFunction) {
            HttpResult.Builder<Object> builder = new HttpResult.Builder().setHttpStatus(FluentResponse.this.actualHttpStatus);
            if (FluentResponse.this.isInExpectedHttpStatuses()) {
                builder.setValue(buildFunction.apply((Object)this.content));
            }
            builder.setETagValue(FluentResponse.this.httpResponse.header("ETag"));
            return builder.build();
        }
    }

    public final class JSONResponse<T> {
        private final SDKOptional<JSONObject> jsonObjectOptional;

        private JSONResponse(SDKOptional<JSONObject> jsonObject) {
            this.jsonObjectOptional = jsonObject;
        }

        public HttpResult<T> toSingleEntity(SDKFunction<JSONObject, T> buildFunction) {
            HttpResult.Builder<Object> resultBuilder = new HttpResult.Builder().setHttpStatus(FluentResponse.this.actualHttpStatus).setReasonPhrase(FluentResponse.this.httpResponse.message());
            if (!this.jsonObjectOptional.isPresent()) {
                return resultBuilder.build();
            }
            final JSONObject jsonObject = (JSONObject)this.jsonObjectOptional.get();
            resultBuilder.setSearchMeta((SearchMeta)JSONUtils.transformOrReturnNull((JSONObject)jsonObject, (String)"searchMeta", (SDKFunction)new SDKFunction<JSONObject, SearchMeta>(){

                public SearchMeta apply(JSONObject object) {
                    try {
                        return SearchMeta.from(jsonObject.getJSONObject("searchMeta"));
                    }
                    catch (JSONException e) {
                        throw new IllegalStateException(e);
                    }
                }
            })).setETagValue(FluentResponse.this.httpResponse.header("ETag")).setHttpStatus(FluentResponse.this.actualHttpStatus).setSearchMeta(FluentResponse.parseSearchMeta(jsonObject));
            if (FluentResponse.this.isInExpectedHttpStatuses()) {
                resultBuilder.setValue(buildFunction.apply((Object)jsonObject));
            }
            return resultBuilder.build();
        }

        public HttpResult<List<T>> toList(String jsonEntry, SDKFunction<JSONObject, T> buildFunction) {
            HttpResult.Builder resultBuilder = new HttpResult.Builder().setETagValue(FluentResponse.this.httpResponse.header("ETag")).setHttpStatus(FluentResponse.this.actualHttpStatus).setReasonPhrase(FluentResponse.this.httpResponse.message());
            if (!this.jsonObjectOptional.isPresent()) {
                return resultBuilder.build();
            }
            final JSONObject jsonObject = (JSONObject)this.jsonObjectOptional.get();
            resultBuilder.setSearchMeta((SearchMeta)JSONUtils.transformOrReturnNull((JSONObject)jsonObject, (String)"searchMeta", (SDKFunction)new SDKFunction<JSONObject, SearchMeta>(){

                public SearchMeta apply(JSONObject object) {
                    try {
                        return SearchMeta.from(jsonObject.getJSONObject("searchMeta"));
                    }
                    catch (JSONException e) {
                        throw new IllegalStateException(e);
                    }
                }
            })).setETagValue(FluentResponse.this.httpResponse.header("ETag")).setHttpStatus(FluentResponse.this.actualHttpStatus).setSearchMeta(FluentResponse.parseSearchMeta(jsonObject));
            try {
                if (FluentResponse.this.isInExpectedHttpStatuses()) {
                    JSONArray jsonArray = jsonObject.getJSONArray(jsonEntry);
                    ArrayList<Object> itemList = new ArrayList<Object>();
                    int size = jsonArray.length();
                    for (int i = 0; i < size; ++i) {
                        itemList.add(buildFunction.apply((Object)jsonArray.getJSONObject(i)));
                    }
                    resultBuilder.setValue(Collections.unmodifiableList(itemList));
                }
                return resultBuilder.build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

