/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import android.text.TextUtils;
import com.kontakt.sdk.android.common.FileData;
import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.Firmware;
import com.kontakt.sdk.android.common.model.IFirmware;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.SDKOptional;
import com.kontakt.sdk.android.http.AbstractApiAccessor;
import com.kontakt.sdk.android.http.ETag;
import com.kontakt.sdk.android.http.HttpResult;
import com.kontakt.sdk.android.http.RequestDescription;
import com.kontakt.sdk.android.http.exception.ClientException;
import com.kontakt.sdk.android.http.interfaces.FirmwareApiAccessor;
import com.kontakt.sdk.android.http.interfaces.ResultApiCallback;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

final class FirmwareApiAccessorImpl
extends AbstractApiAccessor
implements FirmwareApiAccessor {
    FirmwareApiAccessorImpl(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
    }

    @Override
    public HttpResult<Map<String, IFirmware>> getLatestFirmwareForBeacons(final Set<String> beaconUniqueIds, SDKOptional<ETag> eTagOptional) throws ClientException {
        List parameterList = HttpUtils.toUrlParameterList((String)"uniqueId", beaconUniqueIds);
        Headers.Builder headersBuilder = new Headers.Builder();
        if (eTagOptional.isPresent()) {
            ETag eTag = (ETag)eTagOptional.get();
            headersBuilder.add(eTag.getRequestName(), eTag.getValue());
        }
        try {
            Response response = this.get("firmware/last", headersBuilder.build(), parameterList);
            return FirmwareApiAccessorImpl.transformJSONToEntity(response, 200, new SDKFunction<JSONObject, Map<String, IFirmware>>(){

                public Map<String, IFirmware> apply(JSONObject object) {
                    try {
                        return FirmwareApiAccessorImpl.this.toFirmwareMap(object, beaconUniqueIds);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    @Override
    public HttpResult<Map<String, IFirmware>> getLatestFirmwareForBeacons(Set<String> beaconUniqueIds) throws ClientException {
        return this.getLatestFirmwareForBeacons(beaconUniqueIds, (SDKOptional<ETag>)SDKOptional.absent());
    }

    private Map<String, IFirmware> toFirmwareMap(JSONObject object, Set<String> deviceUniqueIds) throws JSONException {
        HashMap<String, IFirmware> firmwareMap = new HashMap<String, IFirmware>();
        for (String beaconUniqueId : deviceUniqueIds) {
            firmwareMap.put(beaconUniqueId, null);
            if (!object.has(beaconUniqueId)) continue;
            JSONObject jsonObject = object.getJSONObject(beaconUniqueId);
            firmwareMap.put(beaconUniqueId, (IFirmware)Firmware.from((JSONObject)jsonObject));
        }
        return firmwareMap;
    }

    @Override
    public void getLatestFirmwareForBeacons(final Set<String> deviceUniqueIds, SDKOptional<ETag> eTag, ResultApiCallback<Map<String, IFirmware>> callback) {
        this.getAsyncAndRetrieveFromJSONObject("firmware/last", DEFAULT_REQUEST_DESCRIPTION, 200, callback, new SDKFunction<JSONObject, Map<String, IFirmware>>(){

            public Map<String, IFirmware> apply(JSONObject object) {
                try {
                    return FirmwareApiAccessorImpl.this.toFirmwareMap(object, deviceUniqueIds);
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    @Override
    public void getLatestFirmwareForBeacons(Set<String> deviceUniqueIds, ResultApiCallback<Map<String, IFirmware>> callback) {
        this.getLatestFirmwareForBeacons(deviceUniqueIds, (SDKOptional<ETag>)SDKOptional.absent(), callback);
    }

    @Override
    public HttpResult<IFirmware> getFirmware(String firmwareName, DeviceType deviceType, SDKOptional<ETag> eTag) throws ClientException {
        String uri = String.format("firmware/%s", firmwareName);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addParameter("deviceType", deviceType.name()).build();
        return this.getAndTransform(uri, requestDescription, new SDKFunction<JSONObject, IFirmware>(){

            public IFirmware apply(JSONObject object) {
                return Firmware.from((JSONObject)object);
            }
        });
    }

    @Override
    public HttpResult<IFirmware> getFirmware(String firmwareName, DeviceType deviceType) throws ClientException {
        return this.getFirmware(firmwareName, deviceType, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void getFirmware(String firmwareName, DeviceType deviceType, SDKOptional<ETag> eTag, ResultApiCallback<IFirmware> apiCallback) {
        String uri = String.format("firmware/%s", firmwareName);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).addHeader("deviceType", deviceType.name()).build();
        this.getAsyncAndRetrieveFromJSONObject(uri, requestDescription, 200, apiCallback, new SDKFunction<JSONObject, IFirmware>(){

            public IFirmware apply(JSONObject object) {
                return Firmware.from((JSONObject)object);
            }
        });
    }

    @Override
    public void getFirmware(String firmwareName, DeviceType deviceType, ResultApiCallback<IFirmware> apiCallback) {
        this.getFirmware(firmwareName, deviceType, (SDKOptional<ETag>)SDKOptional.absent(), apiCallback);
    }

    @Override
    public HttpResult<FileData> fetchFirmwareFileData(String firmwareName, SDKOptional<ETag> eTag) throws ClientException {
        String uri = String.format("firmware/%s/file", firmwareName);
        RequestDescription requestDescription = RequestDescription.start().setETag(eTag.isPresent() ? (ETag)eTag.get() : null).build();
        return this.getAndTransformByteArray(uri, requestDescription, new SDKFunction<byte[], FileData>(){

            public FileData apply(byte[] object) {
                return FileData.of((byte[])object);
            }
        });
    }

    @Override
    public HttpResult<FileData> fetchFirmwareFileData(String firmwareName) throws ClientException {
        return this.fetchFirmwareFileData(firmwareName, (SDKOptional<ETag>)SDKOptional.absent());
    }

    @Override
    public void fetchFirmwareFileData(String firmwareName, SDKOptional<ETag> etag, ResultApiCallback<FileData> resultApiCallback) {
        String uri = String.format("firmware/%s/file", firmwareName);
        RequestDescription requestDescription = RequestDescription.start().setETag(etag.isPresent() ? (ETag)etag.get() : null).build();
        this.getAsyncAndRetrieveFromByteArray(uri, requestDescription, resultApiCallback, new SDKFunction<byte[], FileData>(){

            public FileData apply(byte[] object) {
                return FileData.of((byte[])object);
            }
        });
    }

    @Override
    public void fetchFirmwareFileData(String firmwareName, ResultApiCallback<FileData> resultApiCallback) {
        this.fetchFirmwareFileData(firmwareName, (SDKOptional<ETag>)SDKOptional.absent(), resultApiCallback);
    }

    @Override
    public HttpResult<List<IFirmware>> getFirmwares(Set<String> deviceUniqueIds) throws ClientException {
        String parameters = TextUtils.join((CharSequence)",", deviceUniqueIds);
        RequestDescription requestDescription = RequestDescription.start().addParameter("uniqueId", parameters).build();
        return this.getAndTransform("firmware", requestDescription, new SDKFunction<JSONObject, List<IFirmware>>(){

            public List<IFirmware> apply(JSONObject object) {
                return Firmware.fromList((JSONObject)object);
            }
        });
    }

    @Override
    public void getFirmwares(Set<String> deviceUniqueIds, ResultApiCallback<List<IFirmware>> apiCallback) {
    }
}

