/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http;

import com.kontakt.sdk.android.common.model.BrowserAction;
import com.kontakt.sdk.android.common.model.ContentAction;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.model.IBrowserAction;
import com.kontakt.sdk.android.common.model.IContentAction;
import com.kontakt.sdk.android.common.model.IPreset;
import com.kontakt.sdk.android.common.model.Preset;
import com.kontakt.sdk.android.common.util.JSONUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ExtractUtils {
    private static final String PRESETS = "presets";

    private ExtractUtils() {
    }

    static List<IAction> extractActions(JSONObject jsonObject) {
        JSONArray jsonArray = JSONUtils.getJSONArray((JSONObject)jsonObject, (String)"actions", null);
        if (jsonArray == null) {
            return new ArrayList<IAction>();
        }
        ArrayList<IAction> actions = new ArrayList<IAction>();
        int length = jsonArray.length();
        for (int i = 0; i < length; ++i) {
            try {
                actions.add(ExtractUtils.extractAction(jsonArray.getJSONObject(i)));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return actions;
    }

    static IAction extractAction(JSONObject jsonObject) {
        String actionType = JSONUtils.getStringOrNull((JSONObject)jsonObject, (String)"actionType");
        IAction.ActionType type = IAction.ActionType.valueOf((String)actionType);
        if (IAction.ActionType.BROWSER == type) {
            return ExtractUtils.parseBrowserAction(jsonObject);
        }
        if (IAction.ActionType.CONTENT == type) {
            return ExtractUtils.parseContentAction(jsonObject);
        }
        return null;
    }

    static IBrowserAction parseBrowserAction(JSONObject object) {
        return BrowserAction.from((JSONObject)object);
    }

    static IContentAction parseContentAction(JSONObject object) {
        return ContentAction.from((JSONObject)object);
    }

    static List<IPreset> toProfileList(JSONObject object) throws JSONException {
        JSONArray array = object.getJSONArray(PRESETS);
        ArrayList<Preset> profiles = new ArrayList<Preset>();
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            profiles.add(Preset.from((JSONObject)array.getJSONObject(i)));
        }
        return Collections.unmodifiableList(profiles);
    }
}

